/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.particle;

import lombok.Generated;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import sba.sl.b.Block;
import sba.sl.e.Entity;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.compat.v1_21_3.TargetColorCompat;
import sba.sl.impl.bukkit.utils.ColorUtils;
import sba.sl.pa.DustOptions;
import sba.sl.pa.DustTransition;
import sba.sl.pa.FloatData;
import sba.sl.pa.IntegerData;
import sba.sl.pa.ParticleColor;
import sba.sl.pa.ParticleData;
import sba.sl.pa.Spell;
import sba.sl.pa.Trail;
import sba.sl.pa.Vibration;
import sba.sl.w.Location;

public final class BukkitParticleConverter {
    public static Object convertParticleData(@NotNull ParticleData data) {
        if (data instanceof Block) {
            if (BukkitFeature.FLATTENING.isSupported()) {
                return ((Block)data).as(BlockData.class);
            }
            return ((Block)data).as(MaterialData.class);
        }
        if (data instanceof ItemType) {
            return ((ItemType)data).as(org.bukkit.inventory.ItemStack.class);
        }
        if (data instanceof ItemStack) {
            return ((ItemStack)data).as(org.bukkit.inventory.ItemStack.class);
        }
        if (data instanceof DustOptions) {
            return new Particle.DustOptions(ColorUtils.getBukkitColor(((DustOptions)data).color()), ((DustOptions)data).size());
        }
        if (data instanceof DustTransition) {
            return new Particle.DustTransition(ColorUtils.getBukkitColor(((DustTransition)data).fromColor()), ColorUtils.getBukkitColor(((DustTransition)data).toColor()), ((DustTransition)data).size());
        }
        if (data instanceof FloatData) {
            return Float.valueOf(((FloatData)data).get());
        }
        if (data instanceof IntegerData) {
            return ((IntegerData)data).get();
        }
        if (data instanceof Vibration) {
            Location origin = ((Vibration)data).origin();
            Vibration.Destination dest = ((Vibration)data).destination();
            return new org.bukkit.Vibration(origin != null ? origin.as(org.bukkit.Location.class) : new org.bukkit.Location(null, 0.0, 0.0, 0.0), (Vibration.Destination)(dest instanceof Entity ? new Vibration.Destination.EntityDestination(dest.as(org.bukkit.entity.Entity.class)) : new Vibration.Destination.BlockDestination(dest.as(org.bukkit.Location.class))), ((Vibration)data).arrivalTime());
        }
        if (data instanceof ParticleColor) {
            return ColorUtils.getBukkitColor(((ParticleColor)data).color());
        }
        if (data instanceof Trail) {
            if (BukkitFeature.TRAIL_PARTICLE_API.isSupported()) {
                return new Particle.Trail(((Trail)data).location().as(org.bukkit.Location.class), ColorUtils.getBukkitColor(((Trail)data).color()), ((Trail)data).duration());
            }
            if (BukkitFeature.TARGET_COLOR_PARTICLE_API.isSupported()) {
                return TargetColorCompat.convertTargetColor((Trail)data);
            }
        } else if (data instanceof Spell && BukkitFeature.PARTICLE_SPELL.isSupported()) {
            return new Particle.Spell(ColorUtils.getBukkitColor(((Spell)data).color()), ((Spell)data).power());
        }
        return null;
    }

    @Generated
    private BukkitParticleConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

