/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.player;

import io.netty.channel.Channel;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.player.BukkitOfflinePlayer;
import sba.sl.impl.bukkit.player.GenericCommandSender;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.network.ConnectionAccessor;
import sba.sl.impl.nms.accessors.server.level.ServerPlayerAccessor;
import sba.sl.impl.nms.accessors.server.network.ServerCommonPacketListenerImplAccessor;
import sba.sl.impl.nms.accessors.server.network.ServerGamePacketListenerImplAccessor;
import sba.sl.pa.Players;
import sba.sl.s.permissions.AndPermission;
import sba.sl.s.permissions.OrPermission;
import sba.sl.s.permissions.Permission;
import sba.sl.s.permissions.PredicatePermission;
import sba.sl.s.permissions.SimplePermission;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.Service;
import sba.sl.u.reflect.Reflect;

@Service
public class BukkitPlayers
extends Players {
    public BukkitPlayers() {
        this.offlinePlayerConverter.registerP2W(OfflinePlayer.class, BukkitOfflinePlayer::new).registerP2W(sba.sl.pa.Player.class, playerWrapper -> new BukkitOfflinePlayer(Bukkit.getOfflinePlayer((UUID)playerWrapper.getUuid())));
    }

    @Override
    @Nullable
    public sba.sl.pa.Player getPlayer0(@NotNull String name) {
        Player bukkitPlayer = Bukkit.getPlayer((String)name);
        return bukkitPlayer == null ? null : new BukkitPlayer(bukkitPlayer);
    }

    @Override
    @Nullable
    public sba.sl.pa.Player getPlayer0(@NotNull UUID uuid) {
        Player bukkitPlayer = Bukkit.getPlayer((UUID)uuid);
        return bukkitPlayer == null ? null : new BukkitPlayer(bukkitPlayer);
    }

    @Override
    @NotNull
    protected <T> sba.sl.s.CommandSender wrapSender0(@NotNull T sender) {
        if (sender instanceof sba.sl.s.CommandSender) {
            return (sba.sl.s.CommandSender)sender;
        }
        if (sender instanceof sba.sl.pa.OfflinePlayer) {
            return Preconditions.checkNotNull(this.getPlayer0(((sba.sl.pa.OfflinePlayer)sender).getUuid()));
        }
        if (sender instanceof Player) {
            return new BukkitPlayer((Player)sender);
        }
        if (sender instanceof OfflinePlayer) {
            return Preconditions.checkNotNull(this.getPlayer0(((OfflinePlayer)sender).getUniqueId()));
        }
        if (sender instanceof CommandSender) {
            return new GenericCommandSender((CommandSender)sender);
        }
        throw new UnsupportedOperationException("Can't wrap " + String.valueOf(sender) + " to CommandSenderWrapper");
    }

    @Override
    public boolean hasPermission0(@NotNull sba.sl.s.CommandSender wrapper, @NotNull Permission permission) {
        if (wrapper.isOp()) {
            return true;
        }
        if (permission instanceof SimplePermission) {
            if (this.isPermissionSet0(wrapper, permission)) {
                return wrapper.as(CommandSender.class).hasPermission(((SimplePermission)permission).getPermissionString());
            }
            return ((SimplePermission)permission).isDefaultAllowed();
        }
        if (permission instanceof AndPermission) {
            return ((AndPermission)permission).getPermissions().stream().allMatch(permission1 -> this.hasPermission0(wrapper, (Permission)permission1));
        }
        if (permission instanceof OrPermission) {
            return ((OrPermission)permission).getPermissions().stream().anyMatch(permission1 -> this.hasPermission0(wrapper, (Permission)permission1));
        }
        if (permission instanceof PredicatePermission) {
            return permission.hasPermission(wrapper);
        }
        return false;
    }

    @Override
    public boolean isPermissionSet0(@NotNull sba.sl.s.CommandSender wrapper, @NotNull Permission permission) {
        if (permission instanceof SimplePermission) {
            return wrapper.as(CommandSender.class).isPermissionSet(((SimplePermission)permission).getPermissionString());
        }
        return true;
    }

    @Override
    @NotNull
    public sba.sl.pa.OfflinePlayer getOfflinePlayer0(@NotNull UUID uuid) {
        OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offPlayer instanceof Player) {
            return new BukkitPlayer((Player)offPlayer);
        }
        return new BukkitOfflinePlayer(offPlayer);
    }

    @Override
    @Nullable
    public sba.sl.pa.OfflinePlayer getOfflinePlayer0(@NotNull String name) {
        OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((String)name);
        if (offPlayer instanceof Player) {
            return new BukkitPlayer((Player)offPlayer);
        }
        return new BukkitOfflinePlayer(offPlayer);
    }

    @Override
    @Nullable
    public sba.sl.pa.Player getPlayerExact0(@NotNull String name) {
        Player bukkitPlayer = Bukkit.getPlayerExact((String)name);
        return bukkitPlayer == null ? null : new BukkitPlayer(bukkitPlayer);
    }

    @Override
    protected Channel getNettyChannel0(sba.sl.pa.Player playerWrapper) {
        Player bukkitPlayer = playerWrapper.as(Player.class);
        return (Channel)Reflect.getFieldResulted(ClassStorage.getHandle(bukkitPlayer), ServerPlayerAccessor.FIELD_CONNECTION.get()).getFieldResulted(ServerCommonPacketListenerImplAccessor.FIELD_CONNECTION.get() != null ? ServerCommonPacketListenerImplAccessor.FIELD_CONNECTION.get() : ServerGamePacketListenerImplAccessor.FIELD_CONNECTION.get()).getFieldResulted(ConnectionAccessor.FIELD_CHANNEL.get()).raw();
    }
}

