/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.plugin;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.pu.Plugin;
import sba.sl.u.BasicWrapper;

public class BukkitPlugin
extends BasicWrapper<Plugin>
implements sba.sl.pu.Plugin {
    public BukkitPlugin(@NotNull Plugin wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @Nullable
    public Object getInstance() {
        return this.wrappedObject;
    }

    @Override
    public boolean isEnabled() {
        return ((Plugin)this.wrappedObject).isEnabled();
    }

    @Override
    @NotNull
    public String pluginKey() {
        return ((Plugin)this.wrappedObject).getName();
    }

    @Override
    @NotNull
    public String name() {
        return ((Plugin)this.wrappedObject).getName();
    }

    @Override
    @NotNull
    public String version() {
        return ((Plugin)this.wrappedObject).getDescription().getVersion();
    }

    @Override
    @Nullable
    public String description() {
        return ((Plugin)this.wrappedObject).getDescription().getDescription();
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull List< @NotNull Plugin.Contributor> contributors() {
        return ((Plugin)this.wrappedObject).getDescription().getAuthors().stream().map(BukkitContributor::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull List< @NotNull Plugin.Dependency> dependencies() {
        PluginDescriptionFile description = ((Plugin)this.wrappedObject).getDescription();
        List depend = description.getDepend();
        List softDepend = description.getSoftDepend();
        List loadBefore = description.getLoadBefore();
        softDepend.removeAll(depend);
        loadBefore.removeAll(depend);
        softDepend.removeAll(loadBefore);
        Stream<BukkitDependency> dependStream = depend.stream().map(s -> new BukkitDependency((String)s, true, Plugin.Dependency.LoadOrder.AFTER));
        Stream<BukkitDependency> softDependStream = softDepend.stream().map(s -> new BukkitDependency((String)s, false, Plugin.Dependency.LoadOrder.AFTER));
        Stream<BukkitDependency> loadBeforeStream = loadBefore.stream().map(s -> new BukkitDependency((String)s, false, Plugin.Dependency.LoadOrder.BEFORE));
        return Stream.of(dependStream, softDependStream, loadBeforeStream).flatMap(s -> s).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public Path dataFolder() {
        return ((Plugin)this.wrappedObject).getDataFolder().toPath().toAbsolutePath();
    }

    public static class BukkitDependency
    implements Plugin.Dependency {
        @NotNull
        private final String pluginKey;
        private final boolean required;
        @NotNull
        private final Plugin.Dependency.LoadOrder loadOrder;

        @Override
        @Nullable
        public String requiredVersion() {
            return null;
        }

        @Generated
        public BukkitDependency(@NotNull String pluginKey, boolean required, @NotNull Plugin.Dependency.LoadOrder loadOrder) {
            if (pluginKey == null) {
                throw new NullPointerException("pluginKey is marked non-null but is null");
            }
            if (loadOrder == null) {
                throw new NullPointerException("loadOrder is marked non-null but is null");
            }
            this.pluginKey = pluginKey;
            this.required = required;
            this.loadOrder = loadOrder;
        }

        @Override
        @NotNull
        @Generated
        public String pluginKey() {
            return this.pluginKey;
        }

        @Override
        @Generated
        public boolean required() {
            return this.required;
        }

        @Override
        @NotNull
        @Generated
        public Plugin.Dependency.LoadOrder loadOrder() {
            return this.loadOrder;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BukkitDependency)) {
                return false;
            }
            BukkitDependency other = (BukkitDependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.required() != other.required()) {
                return false;
            }
            String this$pluginKey = this.pluginKey();
            String other$pluginKey = other.pluginKey();
            if (this$pluginKey == null ? other$pluginKey != null : !this$pluginKey.equals(other$pluginKey)) {
                return false;
            }
            Plugin.Dependency.LoadOrder this$loadOrder = this.loadOrder();
            Plugin.Dependency.LoadOrder other$loadOrder = other.loadOrder();
            return !(this$loadOrder == null ? other$loadOrder != null : !((Object)((Object)this$loadOrder)).equals((Object)other$loadOrder));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BukkitDependency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.required() ? 79 : 97);
            String $pluginKey = this.pluginKey();
            result = result * 59 + ($pluginKey == null ? 43 : $pluginKey.hashCode());
            Plugin.Dependency.LoadOrder $loadOrder = this.loadOrder();
            result = result * 59 + ($loadOrder == null ? 43 : ((Object)((Object)$loadOrder)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BukkitPlugin.BukkitDependency(pluginKey=" + this.pluginKey() + ", required=" + this.required() + ", loadOrder=" + String.valueOf((Object)this.loadOrder()) + ")";
        }
    }

    public static class BukkitContributor
    implements Plugin.Contributor {
        @NotNull
        private final String name;

        @Generated
        public BukkitContributor(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Override
        @NotNull
        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BukkitContributor)) {
                return false;
            }
            BukkitContributor other = (BukkitContributor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BukkitContributor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BukkitPlugin.BukkitContributor(name=" + this.name() + ")";
        }
    }
}

