/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator.bossbar;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.legacy.bossbar.BossBar;
import com.viaversion.viaversion.api.legacy.bossbar.BossColor;
import com.viaversion.viaversion.api.legacy.bossbar.BossFlag;
import com.viaversion.viaversion.api.legacy.bossbar.BossStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.impl.bukkit.compat.v1_8_8.bossbar.BossBarDragon;
import sba.sl.impl.bukkit.compat.v1_8_8.bossbar.BossBarWither;
import sba.sl.impl.bukkit.compat.v1_8_8.bossbar.FakeEntityNMS;
import sba.sl.impl.bukkit.spectator.bossbar.GlobalBossBarBackend1_8;
import sba.sl.spectator.Component;
import sba.sl.spectator.bossbar.BossBar;
import sba.sl.spectator.bossbar.BossBarColor;
import sba.sl.spectator.bossbar.BossBarDivision;
import sba.sl.spectator.bossbar.BossBarFlag;
import sba.sl.spectator.bossbar.BossBarListener;
import sba.sl.spectator.bossbar.RegisteredListener;

public class BukkitBossBar1_8
implements sba.sl.spectator.bossbar.BossBar {
    @NotNull
    private final @NotNull List<@NotNull RegisteredListener> internalListeners = new ArrayList<RegisteredListener>();
    @NotNull
    private Component title;
    private float progress;
    @NotNull
    private BossBarColor color;
    @NotNull
    private BossBarDivision division;
    @NotNull
    private @NotNull List<@NotNull BossBarFlag> flags;
    @NotNull
    private final FakeEntityNMS<?> bossbarEntity;
    private final boolean viaActive;
    private BossBar viaBossBar;
    private boolean viaVersionJsonParam;

    public BukkitBossBar1_8(@NotNull Component title, float progress, @NotNull BossBarColor color, @NotNull BossBarDivision division, @NotNull @NotNull List<@NotNull BossBarFlag> flags, @NotNull @NotNull @NotNull Backend backend, boolean enableViaHooks) {
        this.title = title;
        this.progress = progress;
        this.color = color;
        this.division = division;
        this.flags = flags;
        this.bossbarEntity = backend == Backend.ENDER_DRAGON ? new BossBarDragon(new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0)) : new BossBarWither(new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0));
        this.bossbarEntity.setVisible(true);
        boolean viaActive = false;
        if (enableViaHooks && Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
            try {
                String version = Bukkit.getPluginManager().getPlugin("ViaVersion").getDescription().getVersion();
                this.viaVersionJsonParam = Integer.parseInt(version.split("\\.", 2)[0]) >= 5 && !"5.0.0".equals(version) && !"5.0.1".equals(version);
                this.viaBossBar = Via.getAPI().legacyAPI().createLegacyBossBar(this.viaVersionJsonParam ? "{text: \"\"}" : "", 1.0f, BossColor.PURPLE, BossStyle.SOLID);
                this.viaBossBar.show();
                viaActive = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.viaActive = viaActive;
    }

    public void addViewer(@NotNull Player player) {
        if (this.viaActive && Via.getAPI().getPlayerVersion(player.getUniqueId()) >= 107) {
            this.viaBossBar.addPlayer(player.getUniqueId());
            return;
        }
        this.bossbarEntity.addViewer(player);
    }

    public void removeViewer(@NotNull Player player) {
        if (this.viaActive && Via.getAPI().getPlayerVersion(player.getUniqueId()) >= 107) {
            this.viaBossBar.removePlayer(player.getUniqueId());
            return;
        }
        this.bossbarEntity.removeViewer(player);
    }

    @Override
    @NotNull
    public Component title() {
        return this.title;
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar title(@NotNull Component title) {
        Component old = this.title;
        this.title = title;
        this.bossbarEntity.setCustomName(title);
        if (this.viaActive) {
            this.viaBossBar.setTitle(this.viaVersionJsonParam ? title.toJavaJson() : title.toLegacy());
        }
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onTitleChanged(this, old, title));
        return this;
    }

    @Override
    public float progress() {
        return this.progress;
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar progress(float progress) {
        float old = this.progress;
        if (Double.isNaN(progress) || progress < 0.0f) {
            progress = 0.0f;
        } else if (progress > 1.0f) {
            progress = 1.0f;
        }
        this.progress = progress;
        this.bossbarEntity.setHealth(progress);
        if (this.viaActive) {
            this.viaBossBar.setHealth(progress);
        }
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onProgressChanged(this, old, this.progress));
        return this;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull BossBarFlag> flags() {
        return List.copyOf(this.flags);
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar flags(@NotNull @NotNull List<@NotNull BossBarFlag> flags) {
        List<BossBarFlag> old = this.flags;
        this.flags = flags;
        if (this.viaActive) {
            if (flags.contains(BossBarFlag.PLAY_BOSS_MUSIC)) {
                if (!this.viaBossBar.hasFlag(BossFlag.PLAY_BOSS_MUSIC)) {
                    this.viaBossBar.addFlag(BossFlag.PLAY_BOSS_MUSIC);
                }
            } else if (this.viaBossBar.hasFlag(BossFlag.PLAY_BOSS_MUSIC)) {
                this.viaBossBar.removeFlag(BossFlag.PLAY_BOSS_MUSIC);
            }
            if (flags.contains(BossBarFlag.DARKEN_SCREEN)) {
                if (!this.viaBossBar.hasFlag(BossFlag.DARKEN_SKY)) {
                    this.viaBossBar.addFlag(BossFlag.DARKEN_SKY);
                }
            } else if (this.viaBossBar.hasFlag(BossFlag.DARKEN_SKY)) {
                this.viaBossBar.removeFlag(BossFlag.DARKEN_SKY);
            }
            if (flags.contains(BossBarFlag.CREATE_WORLD_FOG)) {
                if (!this.viaBossBar.hasFlag(BossFlag.CREATE_FOG)) {
                    this.viaBossBar.addFlag(BossFlag.CREATE_FOG);
                }
            } else if (this.viaBossBar.hasFlag(BossFlag.CREATE_FOG)) {
                this.viaBossBar.removeFlag(BossFlag.CREATE_FOG);
            }
        }
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onFlagsChanged(this, old, flags));
        return this;
    }

    @Override
    @NotNull
    public BossBarColor color() {
        return this.color;
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar color(@NotNull BossBarColor color) {
        BossBarColor old = this.color;
        this.color = color;
        if (this.viaActive) {
            try {
                this.viaBossBar.setColor(BossColor.valueOf((String)color.name()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onColorChanged(this, old, color));
        return this;
    }

    @Override
    @NotNull
    public BossBarDivision division() {
        return this.division;
    }

    @Override
    @NotNull
    public sba.sl.spectator.bossbar.BossBar division(@NotNull BossBarDivision division) {
        BossBarDivision old = this.division;
        this.division = division;
        if (this.viaActive) {
            try {
                switch (division) {
                    case NO_DIVISION: {
                        this.viaBossBar.setStyle(BossStyle.SOLID);
                        break;
                    }
                    case NOTCHED_6: {
                        this.viaBossBar.setStyle(BossStyle.SEGMENTED_6);
                        break;
                    }
                    case NOTCHED_10: {
                        this.viaBossBar.setStyle(BossStyle.SEGMENTED_10);
                        break;
                    }
                    case NOTCHED_12: {
                        this.viaBossBar.setStyle(BossStyle.SEGMENTED_12);
                        break;
                    }
                    case NOTCHED_20: {
                        this.viaBossBar.setStyle(BossStyle.SEGMENTED_20);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onDivisionChanged(this, old, division));
        return this;
    }

    @Override
    @NotNull
    public RegisteredListener addListener(@NotNull BossBarListener listener) {
        RegisteredListener registered = () -> listener;
        this.internalListeners.add(registered);
        return registered;
    }

    @Override
    public void removeListener(@NotNull RegisteredListener listener) {
        this.internalListeners.remove(listener);
    }

    @Override
    @NotNull
    public Object raw() {
        throw new UnsupportedOperationException("Not a wrapper!");
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        throw new UnsupportedOperationException("Not a wrapper!");
    }

    public static enum Backend {
        WITHER,
        ENDER_DRAGON;

    }

    public static class BukkitBossBarBuilder
    implements BossBar.Builder {
        @NotNull
        private Component title = Component.empty();
        private float progress;
        @NotNull
        private BossBarColor color = BossBarColor.PINK;
        @NotNull
        private BossBarDivision division = BossBarDivision.NO_DIVISION;
        private @Nullable Collection<@NotNull BossBarFlag> flags;
        @NotNull
        private final @NotNull List<@NotNull BossBarListener> listeners = new ArrayList<BossBarListener>();
        private boolean enableViaHooks = GlobalBossBarBackend1_8.isViaHooks();
        @NotNull
        private Backend backend = GlobalBossBarBackend1_8.getBackend();

        @Override
        @NotNull
        public BossBar.Builder flags(@NotNull @NotNull Collection<@NotNull BossBarFlag> flags) {
            this.flags = flags;
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder flags(BossBarFlag ... flags) {
            this.flags = Arrays.asList(flags);
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder listener(@NotNull BossBarListener listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder enableViaHooks(boolean enableViaHooks) {
            this.enableViaHooks = enableViaHooks;
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder preferEnderDragonBossBar(boolean preferEnderDragonBossBar) {
            this.backend = preferEnderDragonBossBar ? Backend.ENDER_DRAGON : Backend.WITHER;
            return this;
        }

        @Override
        public @NotNull sba.sl.spectator.bossbar.BossBar build() {
            BukkitBossBar1_8 boss = new BukkitBossBar1_8(this.title, this.progress, this.color, this.division, this.flags == null ? List.of() : List.copyOf(this.flags), this.backend, this.enableViaHooks);
            this.listeners.forEach(boss::addListener);
            return boss;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder title(@NotNull Component title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder progress(float progress) {
            this.progress = progress;
            return this;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder color(@NotNull BossBarColor color) {
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.color = color;
            return this;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder division(@NotNull BossBarDivision division) {
            if (division == null) {
                throw new NullPointerException("division is marked non-null but is null");
            }
            this.division = division;
            return this;
        }

        @Generated
        public BukkitBossBarBuilder backend(@NotNull Backend backend) {
            if (backend == null) {
                throw new NullPointerException("backend is marked non-null but is null");
            }
            this.backend = backend;
            return this;
        }
    }
}

