/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.world.dimension;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.world.dimension.BukkitDimensionType;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.impl.world.dimension.DimensionRegistry;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;
import sba.sl.w.dimension.DimensionType;

@Service
public class BukkitDimensionRegistry
extends DimensionRegistry {
    public BukkitDimensionRegistry() {
        this.specialType(World.Environment.class, BukkitDimensionType::new);
    }

    @Override
    @Nullable
    protected DimensionType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            World.Environment value = World.Environment.valueOf((String)location.path().toUpperCase(Locale.ROOT));
            return new BukkitDimensionType(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull DimensionType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<World.Environment, DimensionType>(() -> Arrays.stream(World.Environment.values()), BukkitDimensionType::new, environment -> ResourceLocation.of(environment.name()), (environment, literal) -> environment.name().toLowerCase(Locale.ROOT).contains((CharSequence)literal), (environment, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

