/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.spectator;

import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.Color;

@ApiStatus.Internal
public abstract class ColorLink
implements Color {
    @Override
    public int red() {
        return this.obtainColor().red();
    }

    @Override
    public int green() {
        return this.obtainColor().green();
    }

    @Override
    public int blue() {
        return this.obtainColor().blue();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        return this.obtainColor().as(type);
    }

    public boolean equals(Object obj) {
        return this.obtainColor().equals(obj);
    }

    public int hashCode() {
        return this.obtainColor().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.obtainColor().toString();
    }

    @Override
    @NotNull
    public Object raw() {
        return this.obtainColor().raw();
    }

    @NotNull
    protected abstract Color obtainColor();

    public static class RGB
    extends ColorLink {
        private final int red;
        private final int green;
        private final int blue;
        @Nullable
        private Color cache;

        @Override
        @NotNull
        protected Color obtainColor() {
            if (this.cache == null) {
                this.cache = Color.rgb(this.red, this.green, this.blue);
            }
            return this.cache;
        }

        @Generated
        public RGB(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }
    }

    public static class Named
    extends ColorLink {
        @NotNull
        private final String name;
        @Nullable
        private Color cache;

        @Override
        @NotNull
        protected Color obtainColor() {
            if (this.cache == null) {
                this.cache = Spectator.getBackend().named(this.name);
            }
            assert (this.cache != null && !(this.cache instanceof ColorLink));
            return this.cache;
        }

        @Generated
        public Named(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }
}

