/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.si;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.spectator.StaticAudienceComponentLike;
import sba.sl.impl.utils.visual.SimpleCLTextEntry;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundSetDisplayObjectivePacket;
import sba.sl.p.ClientboundSetObjectivePacket;
import sba.sl.p.ClientboundSetPlayerTeamPacket;
import sba.sl.p.ClientboundSetScorePacket;
import sba.sl.pa.Player;
import sba.sl.si.Sidebar;
import sba.sl.si.SidebarManager;
import sba.sl.si.team.ScoreboardTeam;
import sba.sl.si.team.ScoreboardTeamImpl;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.u.data.DataContainer;
import sba.sl.vi.UpdateStrategy;
import sba.sl.vi.impl.AbstractLinedVisual;

public class SidebarImpl
extends AbstractLinedVisual<Sidebar>
implements Sidebar {
    @NotNull
    protected final @NotNull List<@NotNull ScoreboardTeam> teams = new LinkedList<ScoreboardTeam>();
    @Nullable
    protected DataContainer data;
    protected boolean ready;
    protected boolean destroyed;
    @NotNull
    protected AudienceComponentLike title = AudienceComponentLike.empty();
    @NotNull
    private final String objectiveKey;
    @NotNull
    private final @NotNull ConcurrentSkipListMap<@NotNull UUID, ConcurrentSkipListMap<@NotNull Integer, String>> lines = new ConcurrentSkipListMap();

    public SidebarImpl(@NotNull UUID uuid) {
        super(uuid);
        this.objectiveKey = new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    @Nullable
    public ScoreboardTeam getTeam(@NotNull String identifier) {
        return this.teams.stream().filter(scoreboardTeam -> identifier.equals(scoreboardTeam.identifier())).findFirst().orElse(null);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public Sidebar removeTeam(@NotNull String identifier) {
        ScoreboardTeam team = this.getTeam(identifier);
        if (team != null) {
            this.removeTeam(team);
        }
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public Sidebar removeTeam(@NotNull ScoreboardTeam scoreboardTeam) {
        scoreboardTeam.destroy();
        this.teams.remove(scoreboardTeam);
        return this;
    }

    @Override
    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        return !this.data.isEmpty();
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public Sidebar title(@NotNull Component title) {
        return this.title(AudienceComponentLike.of(title));
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public Sidebar title(@NotNull ComponentLike title) {
        this.title = title instanceof AudienceComponentLike ? (AudienceComponentLike)title : AudienceComponentLike.of(title);
        this.updateTitle0();
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public Sidebar update(@NotNull UpdateStrategy strategy) {
        if (this.ready) {
            List.copyOf(this.viewers).forEach(this::updateForPlayer);
        }
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public Sidebar show() {
        if (this.shown()) {
            return this;
        }
        this.ready = true;
        this.visible = true;
        this.viewers.forEach(a -> this.onViewerAdded((Player)a, false));
        this.update();
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public Sidebar hide() {
        if (!this.shown()) {
            return this;
        }
        this.visible = false;
        this.ready = false;
        this.update();
        return this;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.hide();
        this.viewers.clear();
        SidebarManager.removeSidebar(this);
    }

    @Override
    public void onViewerAdded(@NotNull Player player, boolean checkDistance) {
        if (this.visible) {
            this.getCreateObjectivePacket(player).sendPacket(player);
            this.updateForPlayer(player);
            this.getDisplayObjectivePacket().sendPacket(player);
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructCreatePacket().sendPacket(player));
        }
    }

    @Override
    public void onViewerRemoved(@NotNull Player player, boolean checkDistance) {
        if (this.visible) {
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructDestructPacket().sendPacket(player));
            this.getDestroyObjectivePacket().sendPacket(player);
        }
    }

    private void updateForPlayer(Player playerWrapper) {
        ConcurrentSkipListMap<Integer, String> lines = this.lines.get(playerWrapper.getUuid());
        if (lines == null) {
            lines = new ConcurrentSkipListMap();
            this.lines.put(playerWrapper.getUuid(), lines);
        }
        List list = this.lines().entrySet().stream().filter(entry -> (Integer)entry.getKey() >= 0 && (Integer)entry.getKey() <= 15).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(textEntry -> {
            ComponentLike like;
            if (textEntry instanceof SimpleCLTextEntry && (like = ((SimpleCLTextEntry)textEntry).getComponentLike()) instanceof AudienceComponentLike) {
                return ((AudienceComponentLike)like).asComponentList(playerWrapper);
            }
            return textEntry.getText();
        }).flatMap(o -> {
            if (o instanceof List) {
                return ((List)o).stream();
            }
            return Stream.of((Component)o);
        }).map(Component::toLegacy).collect(Collectors.toList());
        Collections.reverse(list);
        list.replaceAll(toUnique -> this.makeUnique((String)toUnique, list));
        ArrayList<AbstractPacket> packets = new ArrayList<AbstractPacket>();
        if (!(this.title instanceof StaticAudienceComponentLike)) {
            packets.add(this.getUpdateObjectivePacket(playerWrapper));
        }
        ArrayList<Integer> forRemoval = new ArrayList<Integer>();
        for (int i = 0; i < 15; ++i) {
            if (i < list.size()) {
                if (lines.containsKey(i)) {
                    packets.add(this.destroyScore(lines.get(i)));
                }
                lines.put(i, (String)list.get(i));
                packets.add(this.getCreateScorePacket(i, (String)list.get(i)));
                continue;
            }
            if (!lines.containsKey(i)) continue;
            packets.add(this.destroyScore(lines.get(i)));
            forRemoval.add(i);
        }
        forRemoval.forEach(lines::remove);
        packets.forEach(packet -> packet.sendPacket(playerWrapper));
    }

    public void updateTitle0() {
        if (this.visible && !this.viewers.isEmpty()) {
            this.viewers.forEach(p -> this.getUpdateObjectivePacket((Player)p).sendPacket((Player)p));
        }
    }

    @NotNull
    private ClientboundSetObjectivePacket getCreateObjectivePacket(@NotNull Player player) {
        return this.getNotFinalObjectivePacket(player).mode(ClientboundSetObjectivePacket.Mode.CREATE).build();
    }

    @NotNull
    private ClientboundSetObjectivePacket getUpdateObjectivePacket(@NotNull Player player) {
        return this.getNotFinalObjectivePacket(player).mode(ClientboundSetObjectivePacket.Mode.UPDATE).build();
    }

    @NotNull
    private ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder getNotFinalObjectivePacket(@NotNull Player player) {
        return ClientboundSetObjectivePacket.builder().objectiveKey(this.objectiveKey).title(this.title.asComponent(player)).criteriaType(ClientboundSetObjectivePacket.Type.INTEGER);
    }

    @NotNull
    private ClientboundSetObjectivePacket getDestroyObjectivePacket() {
        return ClientboundSetObjectivePacket.builder().objectiveKey(this.objectiveKey).mode(ClientboundSetObjectivePacket.Mode.DESTROY).build();
    }

    @NotNull
    private ClientboundSetDisplayObjectivePacket getDisplayObjectivePacket() {
        return ClientboundSetDisplayObjectivePacket.builder().objectiveKey(this.objectiveKey).slot(ClientboundSetDisplayObjectivePacket.DisplaySlot.SIDEBAR).build();
    }

    @NotNull
    private ClientboundSetScorePacket getCreateScorePacket(int i, @NotNull String value) {
        return ClientboundSetScorePacket.builder().entityName(value).objectiveKey(this.objectiveKey).score(i).action(ClientboundSetScorePacket.ScoreboardAction.CHANGE).build();
    }

    @NotNull
    private ClientboundSetScorePacket destroyScore(@NotNull String value) {
        return ClientboundSetScorePacket.builder().entityName(value).objectiveKey(this.objectiveKey).action(ClientboundSetScorePacket.ScoreboardAction.REMOVE).build();
    }

    @NotNull
    public String makeUnique(@Nullable String toUnique, @NotNull @NotNull List<@NotNull String> from) {
        if (toUnique == null) {
            toUnique = " ";
        }
        StringBuilder stringBuilder = new StringBuilder(toUnique);
        while (from.contains(stringBuilder.toString())) {
            stringBuilder.append(" ");
        }
        if (stringBuilder.length() > 40) {
            return stringBuilder.substring(0, 40);
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public ScoreboardTeam team(@NotNull String identifier) {
        ScoreboardTeamImpl team = new ScoreboardTeamImpl(this, identifier);
        this.teams.add(team);
        if (this.visible && !this.viewers.isEmpty()) {
            ClientboundSetPlayerTeamPacket packet = team.constructCreatePacket();
            this.viewers.forEach(packet::sendPacket);
        }
        return team;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull ScoreboardTeam> getTeams() {
        return this.teams;
    }

    @Override
    @Nullable
    @Generated
    public DataContainer data() {
        return this.data;
    }

    @Override
    @Generated
    public SidebarImpl data(@Nullable DataContainer data) {
        this.data = data;
        return this;
    }

    @Override
    @Generated
    public boolean destroyed() {
        return this.destroyed;
    }
}

