/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator;

import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.ColorLink;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentBuilderApplicable;
import sba.sl.spectator.ShadowColor;
import sba.sl.u.RawValueHolder;

public interface Color
extends Wrapper,
ComponentBuilderApplicable,
RawValueHolder {
    @NotNull
    public static final Color BLACK = new ColorLink.Named("BLACK");
    @NotNull
    public static final Color DARK_BLUE = new ColorLink.Named("DARK_BLUE");
    @NotNull
    public static final Color DARK_GREEN = new ColorLink.Named("DARK_GREEN");
    @NotNull
    public static final Color DARK_AQUA = new ColorLink.Named("DARK_AQUA");
    @NotNull
    public static final Color DARK_RED = new ColorLink.Named("DARK_RED");
    @NotNull
    public static final Color DARK_PURPLE = new ColorLink.Named("DARK_PURPLE");
    @NotNull
    public static final Color GOLD = new ColorLink.Named("GOLD");
    @NotNull
    public static final Color GRAY = new ColorLink.Named("GRAY");
    @NotNull
    public static final Color DARK_GRAY = new ColorLink.Named("DARK_GRAY");
    @NotNull
    public static final Color BLUE = new ColorLink.Named("BLUE");
    @NotNull
    public static final Color GREEN = new ColorLink.Named("GREEN");
    @NotNull
    public static final Color AQUA = new ColorLink.Named("AQUA");
    @NotNull
    public static final Color RED = new ColorLink.Named("RED");
    @NotNull
    public static final Color LIGHT_PURPLE = new ColorLink.Named("LIGHT_PURPLE");
    @NotNull
    public static final Color YELLOW = new ColorLink.Named("YELLOW");
    @NotNull
    public static final Color WHITE = new ColorLink.Named("WHITE");
    @NotNull
    public static final Color MINECOIN_GOLD = new ColorLink.RGB(221, 214, 5);
    @NotNull
    public static final Color MATERIAL_QUARTZ = new ColorLink.RGB(227, 212, 209);
    @NotNull
    public static final Color MATERIAL_IRON = new ColorLink.RGB(206, 202, 202);
    @NotNull
    public static final Color MATERIAL_NETHERITE = new ColorLink.RGB(68, 58, 59);
    @NotNull
    public static final Color MATERIAL_REDSTONE = new ColorLink.RGB(151, 22, 7);
    @NotNull
    public static final Color MATERIAL_COPPER = new ColorLink.RGB(180, 104, 77);
    @NotNull
    public static final Color MATERIAL_GOLD = new ColorLink.RGB(222, 177, 45);
    @NotNull
    public static final Color MATERIAL_EMERALD = new ColorLink.RGB(71, 160, 54);
    @NotNull
    public static final Color MATERIAL_DIAMOND = new ColorLink.RGB(44, 186, 168);
    @NotNull
    public static final Color MATERIAL_LAPIS = new ColorLink.RGB(33, 73, 123);
    @NotNull
    public static final Color MATERIAL_AMETHYST = new ColorLink.RGB(154, 92, 198);
    @NotNull
    public static final @NotNull Map<@NotNull String, Color> NAMED_VALUES = Map.ofEntries(Map.entry("black", BLACK), Map.entry("dark_blue", DARK_BLUE), Map.entry("dark_green", DARK_GREEN), Map.entry("dark_aqua", DARK_AQUA), Map.entry("dark_red", DARK_RED), Map.entry("dark_purple", DARK_PURPLE), Map.entry("gold", GOLD), Map.entry("gray", GRAY), Map.entry("dark_gray", DARK_GRAY), Map.entry("blue", BLUE), Map.entry("green", GREEN), Map.entry("aqua", AQUA), Map.entry("red", RED), Map.entry("light_purple", LIGHT_PURPLE), Map.entry("yellow", YELLOW), Map.entry("white", WHITE));
    @NotNull
    public static final @NotNull Map<@NotNull String, Color> EXTENDED_NAMED_VALUES = Map.ofEntries(Map.entry("black", BLACK), Map.entry("dark_blue", DARK_BLUE), Map.entry("dark_green", DARK_GREEN), Map.entry("dark_aqua", DARK_AQUA), Map.entry("dark_red", DARK_RED), Map.entry("dark_purple", DARK_PURPLE), Map.entry("gold", GOLD), Map.entry("gray", GRAY), Map.entry("dark_gray", DARK_GRAY), Map.entry("blue", BLUE), Map.entry("green", GREEN), Map.entry("aqua", AQUA), Map.entry("red", RED), Map.entry("light_purple", LIGHT_PURPLE), Map.entry("yellow", YELLOW), Map.entry("white", WHITE), Map.entry("minecoin_gold", MINECOIN_GOLD), Map.entry("material_quartz", MATERIAL_QUARTZ), Map.entry("material_iron", MATERIAL_IRON), Map.entry("material_netherite", MATERIAL_NETHERITE), Map.entry("material_redstone", MATERIAL_REDSTONE), Map.entry("material_copper", MATERIAL_COPPER), Map.entry("material_gold", MATERIAL_GOLD), Map.entry("material_emerald", MATERIAL_EMERALD), Map.entry("material_diamond", MATERIAL_DIAMOND), Map.entry("material_lapis", MATERIAL_LAPIS), Map.entry("material_amethyst", MATERIAL_AMETHYST));

    public int red();

    public int green();

    public int blue();

    default public int compoundRgb() {
        return this.red() << 16 | this.green() << 8 | this.blue();
    }

    @NotNull
    public String toString();

    @NotNull
    public static Color rgb(int red, int green, int blue) {
        return Spectator.getBackend().rgb(red, green, blue);
    }

    @NotNull
    public static Color rgb(int compound) {
        return Spectator.getBackend().rgb(compound >> 16 & 0xFF, compound >> 8 & 0xFF, compound & 0xFF);
    }

    @Nullable
    public static Color named(@NotNull String name) {
        if ("grey".equalsIgnoreCase(name)) {
            name = "gray";
        } else if ("dark_grey".equalsIgnoreCase(name)) {
            name = "dark_gray";
        }
        return EXTENDED_NAMED_VALUES.get(name.toLowerCase(Locale.ROOT));
    }

    @NotNull
    public static Color hexOrName(@NotNull String hex) {
        if ("grey".equalsIgnoreCase(hex)) {
            hex = "gray";
        } else if ("dark_grey".equalsIgnoreCase(hex)) {
            hex = "dark_gray";
        }
        Color value = EXTENDED_NAMED_VALUES.get(hex.toLowerCase(Locale.ROOT));
        if (value != null) {
            return value;
        }
        return Spectator.getBackend().hexOrName(hex);
    }

    @NotNull
    public static Color nearestNamedTo(@Nullable Color color) {
        return Spectator.getBackend().nearestNamedTo(color);
    }

    @NotNull
    public static Color interpolate(float t, @NotNull Color a, @NotNull Color b) {
        float clampedT = Math.min(1.0f, Math.max(0.0f, t));
        int ar = a.red();
        int br = b.red();
        int ag = a.green();
        int bg = b.green();
        int ab = a.blue();
        int bb = b.blue();
        return Color.rgb(Math.round((float)ar + clampedT * (float)(br - ar)), Math.round((float)ag + clampedT * (float)(bg - ag)), Math.round((float)ab + clampedT * (float)(bb - ab)));
    }

    @NotNull
    default public ShadowColor asShadow() {
        return ShadowColor.rgb(this.red(), this.green(), this.blue());
    }

    @NotNull
    default public ShadowColor asShadow(int alpha) {
        return ShadowColor.rgba(this.red(), this.green(), this.blue(), alpha);
    }

    @Override
    default public <C extends Component, B extends Component.Builder<B, C>> void apply(@NotNull B builder) {
        builder.color(this);
    }

    @Override
    @NotNull
    default public Component applyTo(@NotNull Component component) {
        return component.withColor(this);
    }
}

