/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.placeholders;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.DefaultStringLikePlaceholder;
import sba.sl.spectator.mini.placeholders.Placeholder;

public abstract class DateTimePlaceholder
implements DefaultStringLikePlaceholder {
    @Pattern(value="[a-z\\d_-]+")
    @NotNull
    private final String name;

    @NotNull
    public abstract TemporalAccessor getValue();

    @Override
    @NotNull
    public String getStringResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        TemporalAccessor value = this.getValue();
        if (arguments.size() >= 1) {
            try {
                return DateTimeFormatter.ofPattern(arguments.get(0)).format(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return DateTimeFormatter.ISO_DATE_TIME.format(value);
    }

    @Generated
    public DateTimePlaceholder(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateTimePlaceholder)) {
            return false;
        }
        DateTimePlaceholder other = (DateTimePlaceholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DateTimePlaceholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DateTimePlaceholder(name=" + this.getName() + ")";
    }

    public static final class Lazy
    extends DateTimePlaceholder {
        @NotNull
        private final @NotNull Supplier<@NotNull TemporalAccessor> supplier;

        public Lazy(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull TemporalAccessor> supplier) {
            super(name);
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public TemporalAccessor getValue() {
            return this.supplier.get();
        }

        @NotNull
        @Generated
        public @NotNull Supplier<@NotNull TemporalAccessor> getSupplier() {
            return this.supplier;
        }
    }

    public static final class Constant
    extends DateTimePlaceholder {
        @NotNull
        private final TemporalAccessor value;

        public Constant(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull TemporalAccessor value) {
            super(name);
            this.value = value;
        }

        @Override
        @NotNull
        @Generated
        public TemporalAccessor getValue() {
            return this.value;
        }
    }
}

