/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.placeholders;

import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import sba.sl.spectator.Component;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.placeholders.StringLikePlaceholder;

public abstract class MiniPlaceholder
implements Placeholder,
StringLikePlaceholder {
    @Pattern(value="[a-z\\d_-]+")
    @NotNull
    private final String name;

    @NotNull
    public abstract String getValue();

    @Override
    @NotNull
    public <B extends Component.Builder<B, C>, C extends Component> B getResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        return parser.parseIntoBuilder(this.getValue(), placeholders);
    }

    @Override
    @NotNull
    public String getStringResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        return this.getResult(parser, arguments, placeholders).build().toPlainText();
    }

    @Generated
    public MiniPlaceholder(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MiniPlaceholder)) {
            return false;
        }
        MiniPlaceholder other = (MiniPlaceholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MiniPlaceholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MiniPlaceholder(name=" + this.getName() + ")";
    }

    public static final class Lazy
    extends MiniPlaceholder {
        @NotNull
        private final @NotNull Supplier<@NotNull String> supplier;

        public Lazy(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull String> supplier) {
            super(name);
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.supplier.get();
        }

        @NotNull
        @Generated
        public @NotNull Supplier<@NotNull String> getSupplier() {
            return this.supplier;
        }
    }

    public static final class Constant
    extends MiniPlaceholder {
        @NotNull
        private final String value;

        public Constant(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull String value) {
            super(name);
            this.value = value;
        }

        @Override
        @NotNull
        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

