/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.spectator.Component;
import sba.sl.spectator.event.HoverEvent;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.resolvers.StylingResolver;
import sba.sl.u.ResourceLocation;

public class HoverResolver
implements StylingResolver {
    @NotNull
    private static final SNBTSerializer internalSNBTSerializer = SNBTSerializer.builder().shouldSaveLongArraysDirectly(true).build();

    @Override
    public <B extends Component.Builder<B, C>, C extends Component> void applyStyle(@NotNull MiniMessageParser parser, @NotNull B builder, @NotNull TagNode tag, Placeholder ... placeholders) {
        if (tag.getArgs().isEmpty()) {
            return;
        }
        if (tag.getArgs().size() == 1) {
            builder.hoverEvent(parser.parse(tag.getArgs().get(0), placeholders));
            return;
        }
        switch (tag.getArgs().get(0).toLowerCase(Locale.ROOT)) {
            case "show_item": 
            case "item": {
                ItemContent.Builder item = ItemContent.builder();
                item.id(ResourceLocation.of(tag.getArgs().get(1)));
                if (tag.getArgs().size() > 2) {
                    try {
                        int count = Integer.parseInt(tag.getArgs().get(2));
                        item.count(count);
                    }
                    catch (NumberFormatException count) {
                        // empty catch block
                    }
                    if (tag.getArgs().size() > 3) {
                        String snbt = tag.getArgs().get(3);
                        item.tag((CompoundTag)internalSNBTSerializer.deserialize(snbt));
                    }
                }
                builder.hoverEvent(item);
                break;
            }
            case "show_entity": 
            case "entity": {
                if (tag.getArgs().size() <= 2) break;
                EntityContent.Builder entity = EntityContent.builder();
                entity.type(ResourceLocation.of(tag.getArgs().get(1)));
                entity.id(UUID.fromString(tag.getArgs().get(2)));
                if (tag.getArgs().size() > 3) {
                    entity.name(parser.parse(tag.getArgs().get(3), placeholders));
                }
                builder.hoverEvent(entity);
                break;
            }
            default: {
                builder.hoverEvent(parser.parse(tag.getArgs().get(1), placeholders));
            }
        }
    }

    @Override
    @Nullable
    public TagNode serialize(@NotNull MiniMessageParser parser, @NotNull String tagName, @NotNull Component component) {
        HoverEvent hover = component.hoverEvent();
        if (hover != null) {
            switch (hover.action()) {
                case SHOW_ITEM: {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("show_item");
                    ItemContent item = (ItemContent)hover.content();
                    args.add(item.id().asString());
                    int count = item.count();
                    CompoundTag tag = item.tag();
                    if (count != 1 || tag != null) {
                        args.add(String.valueOf(count));
                        if (tag != null) {
                            args.add(internalSNBTSerializer.serialize(tag));
                        }
                    }
                    return new TagNode(tagName, args);
                }
                case SHOW_ENTITY: {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("show_entity");
                    EntityContent entity = (EntityContent)hover.content();
                    args.add(entity.type().asString());
                    args.add(entity.id().toString());
                    Component name = entity.name();
                    if (name != null) {
                        args.add(parser.serialize(name));
                    }
                    return new TagNode(tagName, args);
                }
            }
            return new TagNode(tagName, List.of("show_text", parser.serialize((Component)hover.content())));
        }
        return null;
    }
}

