/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.u.RawValueHolder;

public class BasicWrapper<O>
implements Wrapper,
RawValueHolder {
    @NotNull
    protected final transient O wrappedObject;

    protected BasicWrapper(@NotNull O wrappedObject) {
        if (wrappedObject == null) {
            throw new IllegalArgumentException("BasicWrapper does not accept null as a value!");
        }
        this.wrappedObject = wrappedObject;
    }

    @NotNull
    public static <O> BasicWrapper<O> wrap(@NotNull O wrappedObject) {
        return new BasicWrapper<O>(wrappedObject);
    }

    @Override
    @NotNull
    public Object raw() {
        return this.wrappedObject;
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type.isInstance(this.wrappedObject)) {
            return (T)this.wrappedObject;
        }
        if (type.isInstance(this)) {
            return (T)this;
        }
        throw new UnsupportedOperationException("Can't unwrap object to " + type.getName());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RawValueHolder) {
            obj = ((RawValueHolder)obj).raw();
        }
        return this.wrappedObject.equals(obj);
    }

    public int hashCode() {
        return this.wrappedObject.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.wrappedObject) + ")";
    }
}

