/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u.registry;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItem;

@ApiStatus.Experimental
public interface RegistryItemStream<T extends RegistryItem> {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public RegistryItemStream<T> filterByLocation(@NotNull @NotNull Predicate<@NotNull ResourceLocation> var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public RegistryItemStream<T> filterByLocation(@NotNull Pattern locationPattern) {
        return this.filterByLocation((ResourceLocation loc) -> locationPattern.matcher(loc.asString()).matches());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public RegistryItemStream<T> filterByLocation(@NotNull String regex) {
        Pattern locationPattern = Pattern.compile(regex);
        return this.filterByLocation((ResourceLocation loc) -> locationPattern.matcher(loc.asString()).matches());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public RegistryItemStream<T> filterByLiteralInPath(@NotNull String var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public RegistryItemStream<T> filterByNamespace(@NotNull String var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public RegistryItemStream<T> filter(@NotNull @NotNull Predicate<@NotNull T> var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public RegistryItemStream<T> is(@NotNull Object var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public RegistryItemStream<T> is(Object ... var1);

    @Contract(value="-> new", pure=true)
    @NotNull
    public @NotNull List<@NotNull T> collect();

    @Contract(value="-> new", pure=true)
    @NotNull
    public @NotNull List<@NotNull ResourceLocation> collectLocations();

    @Contract(value="-> new", pure=true)
    @NotNull
    public @NotNull Stream<@NotNull T> javaStream();

    @Contract(value="-> new", pure=true)
    @NotNull
    public @NotNull Stream<@NotNull ResourceLocation> javaStreamOfLocations();
}

