/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.BoardPlayer;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.plugin.Session;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ScoreboardManager
implements Listener {
    private static ScoreboardManager instance;
    private final Map<UUID, Scoreboard> cachedBoards = new HashMap<UUID, Scoreboard>();
    private boolean toReset = true;
    private boolean legacy;
    private JavaPlugin plugin;

    public static ScoreboardManager init(JavaPlugin plugin) {
        Objects.requireNonNull(plugin, "Plugin instance cannot be null");
        Session.makeSession(plugin);
        if (instance != null) {
            instance.onDisable();
        }
        instance = new ScoreboardManager();
        ScoreboardManager.instance.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)instance, (Plugin)plugin);
        String[] bukkitVersion = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        int versionNumber = 0;
        for (int i = 0; i < 2; ++i) {
            versionNumber += Integer.parseInt(bukkitVersion[i]) * (i == 0 ? 100 : 1);
        }
        ScoreboardManager.instance.legacy = versionNumber < 113;
        return instance;
    }

    public static boolean isLegacy() {
        return ScoreboardManager.instance.legacy;
    }

    public static void setResetBoardsOnDisabled(boolean boardsOnDisabled) {
        ScoreboardManager.instance.toReset = boardsOnDisabled;
    }

    public static JavaPlugin getPluginInstance() {
        return ScoreboardManager.instance.plugin;
    }

    public static ScoreboardManager getInstance() {
        return instance;
    }

    public void onDisable() {
        HandlerList.unregisterAll((Listener)instance);
        if (!this.toReset) {
            return;
        }
        List.copyOf(this.cachedBoards.values()).forEach(Scoreboard::destroy);
        this.cachedBoards.clear();
    }

    public void addToCache(Scoreboard board) {
        Objects.requireNonNull(board, "Board cannot be null!");
        this.cachedBoards.put(board.getPlayer().getUniqueId(), board);
    }

    public void removeFromCache(UUID uuid) {
        this.cachedBoards.remove(uuid);
    }

    public Optional<Scoreboard> fromCache(UUID uuid) {
        if (this.cachedBoards.containsKey(uuid)) {
            return Optional.of(this.cachedBoards.get(uuid));
        }
        return Optional.empty();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        this.fromCache(uuid).ifPresent(Scoreboard::destroy);
        this.cachedBoards.remove(uuid);
        BoardPlayer bp = BoardPlayer.getBoardPlayerOrNull(e.getPlayer());
        if (bp != null) {
            bp.kill();
        }
    }
}

