/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.inventories.GamesInventory;
import io.github.pronze.sba.inventories.PlayerTrackerInventory;
import io.github.pronze.sba.lang.Message;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.GamesInventoryService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.visuals.MainLobbyVisualsManager;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import io.leangen.geantyref.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.game.GameStore;
import sba.c.CommentedConfigurationNode;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.yaml.YamlConfigurationLoader;
import sba.cl.annotations.Argument;
import sba.cl.annotations.CommandDescription;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.npc.NPC;
import sba.sl.pa.Player;
import sba.sl.pa.Players;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.u.Pair;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class SBACommand {
    private boolean gamesInvEnabled;
    static boolean init = false;
    static List<String> allGameModes = List.of("solo", "double", "triples", "squads");

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        this.gamesInvEnabled = SBAConfig.getInstance().getBoolean("games-inventory.enabled", true);
        CommandManager.getInstance().getManager().getParserRegistry().registerSuggestionProvider("gameMode", (commandSenderCommandContext, s) -> GamesInventory.getInstance().getGameModeNames());
        CommandManager.getInstance().getManager().getParserRegistry().registerSuggestionProvider("maps", (ctx, s) -> Main.getGameNames());
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="sba reload")
    @CommandDescription(value="reload command")
    @CommandPermission(value="sba.reload")
    private void commandReload(@NotNull CommandSender sender) {
        SBAUtil.reloadPlugin(SBA.getPluginInstance(), sender);
    }

    @CommandMethod(value="sba dump")
    @CommandDescription(value="dump command")
    @CommandPermission(value="sba.dump")
    private void commandDump(@NotNull CommandSender sender) {
        sender.sendMessage("Java version : " + System.getProperty("java.version"));
        String a = Bukkit.getServer().getClass().getPackage().getName();
        String version = a.substring(a.lastIndexOf(46) + 1);
        sender.sendMessage("Server version : " + version);
        sender.sendMessage("Commit id : 29f308b");
        sender.sendMessage("Server : " + Bukkit.getServer().getVersion());
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            sender.sendMessage(plugin.getName() + " " + plugin.getDescription().getVersion());
        }
    }

    @CommandMethod(value="sba debug <enabled>")
    @CommandDescription(value="debug command")
    @CommandPermission(value="sba.debug")
    private void commandDebug(@NotNull CommandSender sender, @Argument(value="enabled") @NotNull boolean enabled) {
        if (enabled) {
            Logger.setMode(Logger.Level.ALL);
        } else {
            Logger.setMode(Logger.Level.WARNING);
        }
    }

    @CommandMethod(value="sba test compass")
    @CommandDescription(value="debug compass command")
    @CommandPermission(value="sba.debug")
    private void commandTestCompass(@NotNull org.bukkit.entity.Player player) {
        PlayerTrackerInventory playerTrackerInventory = new PlayerTrackerInventory(null, SBAConfig.getInstance().spectator().teleporter().name(), target -> player.teleport((Entity)target)).openForPlayer(player);
    }

    @CommandMethod(value="sba test npc")
    @CommandDescription(value="debug npc command")
    @CommandPermission(value="sba.debug")
    private void commandTestNPC(@NotNull org.bukkit.entity.Player sender) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(sender);
        NPC npc = (NPC)((NPC)NPC.of(Objects.requireNonNull(sba.sl.w.Location.fromPlatform(sender.getLocation()))).addViewer(player)).lookAtPlayer(true).displayName(List.of(Component.text("Test NPC, will despawn after 10 seconds").withColor(Color.rgb(139, 69, 19)))).show();
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, npc::destroy, 10L, TaskerTime.SECONDS);
    }

    @CommandMethod(value="sba setlobby")
    @CommandDescription(value="set lobby command")
    @CommandPermission(value="sba.setlobby")
    private void commandSetLobby(@NotNull org.bukkit.entity.Player player) {
        Location location = player.getLocation();
        try {
            ConfigurationNode lobbyNode = SBAConfig.getInstance().node("main-lobby");
            lobbyNode.node("enabled").set(true);
            lobbyNode.node("world").set(location.getWorld().getName());
            lobbyNode.node("x").set(location.getX());
            lobbyNode.node("y").set(location.getY());
            lobbyNode.node("z").set(location.getZ());
            lobbyNode.node("yaw").set(Float.valueOf(location.getYaw()));
            lobbyNode.node("pitch").set(Float.valueOf(location.getPitch()));
            SBAConfig.getInstance().saveConfig();
            LanguageService.getInstance().get(MessageKeys.SUCCESSFULLY_SET_LOBBY).send(Players.wrapPlayer(player));
            MainLobbyVisualsManager.getInstance().reload();
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
        }
    }

    @CommandMethod(value="sba resetconfig")
    @CommandDescription(value="reset sba configuration")
    @CommandPermission(value="sba.reset")
    private void commandReset(@NotNull CommandSender sender) {
        Component component = LanguageService.getInstance().get(MessageKeys.COMMAND_RESETTING).toComponent();
        Players.wrapSender(sender).sendMessage(component);
        SBAConfig.getInstance().upgrade();
        Component c2 = LanguageService.getInstance().get(MessageKeys.RESET_COMMAND_SUCCESS).toComponent();
        Players.wrapSender(sender).sendMessage(c2);
    }

    @CommandMethod(value="sba generate [gamemode] [maps]")
    @CommandDescription(value="generate games inventory configuration files")
    @CommandPermission(value="sba.generate")
    private void commandGenerate(final @NotNull CommandSender sender, @Argument(value="gamemode", suggestions="gameMode") @NotNull String gameMode, @Argument(value="maps", suggestions="maps") @NotNull String[] mapsArg) {
        if (gameMode == null) {
            allGameModes.forEach(g -> this.commandGenerate(sender, (String)g, null));
            return;
        }
        final String stringedGameMode = SBAUtil.capitalizeFirstLetter(gameMode);
        List<String> mapsTmp = null;
        if (mapsArg == null || mapsArg.length == 0) {
            Component message = LanguageService.getInstance().get(MessageKeys.GAMESINV_NO_MAPS).toComponent();
            mapsTmp = Main.getGameNames().stream().filter(gname -> Main.getGame((String)gname).getAvailableTeams().stream().allMatch(t -> t.getMaxPlayers() == ShopUtil.getIntFromMode(gameMode))).collect(Collectors.toList());
            Players.wrapSender(sender).sendMessage(message);
        }
        final List<String> maps = mapsTmp != null ? mapsTmp : List.of(mapsArg);
        Logger.trace("Generating Games Inventory file for game mode: {}", gameMode);
        File file = new File(SBA.getPluginInstance().getDataFolder(), "games-inventory/" + gameMode + ".yml");
        if (file.exists()) {
            Logger.trace("Deleting pre existing games inventory file, status: {}", file.delete());
        }
        try {
            Logger.trace("Creating new games inventory file, status: {}", file.createNewFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.getAbsoluteFile().toPath())).build();
        try {
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load();
            ((CommentedConfigurationNode)root.node(new Object[]{"data"})).setList(new TypeToken<Map<String, String>>(){}, (List)List.of(Map.of("stack", "RED_BED;1;\u00a7aBed Wars \u00a77(%s);\u00a77Play Bed Wars {\u00a77%s}; ;\u00a7eClick to play!".replaceAll(Pattern.quote("%s"), stringedGameMode), "row", "1", "column", "3", "properties", "randomly_join"), Map.of("stack", "BARRIER;1;\u00a7cExit", "row", "3", "column", "4", "properties", "exit"), Map.of("stack", "ENDER_PEARL;1;\u00a7cClick here to rejoin!;\u00a77Click here to rejoin the lastly joined game.", "properties", "rejoin", "row", "3", "column", "8")));
            ((CommentedConfigurationNode)((CommentedConfigurationNode)root.node(new Object[]{"data"})).appendListNode()).set(Map.of("stack", "OAK_SIGN;1;\u00a7aMap Selector \u00a77(%s);\u00a77Pick which map you want to play;\u00a77from a list of available servers.; ;\u00a7eClick to browse!".replaceAll(Pattern.quote("%s"), stringedGameMode), "row", "1", "column", "5", "options", Map.of("rows", "6", "render_actual_rows", "6"), "items", new ArrayList<Map<String, Object>>(){
                {
                    AtomicInteger col = new AtomicInteger(1);
                    AtomicInteger row = new AtomicInteger(1);
                    maps.stream().map(mapName -> Pair.of(Main.getInstance().getGameByName(mapName), mapName)).forEach((? super T game) -> {
                        if (game.getFirst() != null) {
                            col.set(col.get() + 1);
                            if (col.get() > 6) {
                                row.set(row.get() + 1);
                                col.set(2);
                            }
                            if (row.get() > 3) {
                                return;
                            }
                            this.add(Map.of("stack", "PAPER;1;\u00a7a" + ((Game)game.getFirst()).getName() + ";\u00a77" + stringedGameMode + "; ;\u00a7aClick to play", "row", String.valueOf(row.get()), "column", String.valueOf(col.get()), "properties", Map.of("name", "join", "gameName", ((Game)game.getFirst()).getName())));
                        } else {
                            Component message = LanguageService.getInstance().get(MessageKeys.GAMESINV_NO_MAPS_WITH_NAME).replace("%name%", (String)game.getSecond()).toComponent();
                            Players.wrapSender(sender).sendMessage(message);
                        }
                    });
                    this.add(Map.of("stack", "ARROW;1;\u00a7cGo Back", "row", 4, "column", 4, "locate", "main"));
                }
            }));
            loader.save(root);
            Component generated = LanguageService.getInstance().get(MessageKeys.GAMESINV_GENERATED).replace("%gamemode%", gameMode).toComponent();
            Players.wrapSender(sender).sendMessage(generated);
            GamesInventoryService.getInstance().destroy();
            GamesInventoryService.getInstance().loadGamesInv();
            GamesInventory.getInstance().loadInventory();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @CommandMethod(value="sba gamesinv <gamemode>")
    @CommandDescription(value="open GamesInventory for player")
    private void commandGamesInv(@NotNull org.bukkit.entity.Player player, @Argument(value="gamemode", suggestions="gameMode") @NotNull String gameMode) {
        if (!this.gamesInvEnabled) {
            Component disabled = LanguageService.getInstance().get(MessageKeys.GAMES_INV_DISABLED).toComponent();
            Players.wrapPlayer(player).sendMessage(disabled);
            return;
        }
        GamesInventory.getInstance().openForPlayer(player, gameMode);
    }

    @CommandMethod(value="sba join random <gamemode>")
    @CommandDescription(value="open GamesInventory for player")
    private void commandJoinRandom(@NotNull org.bukkit.entity.Player player, @Argument(value="gamemode", suggestions="gameMode") @NotNull String gameMode) {
        if (!this.gamesInvEnabled) {
            Component disabled = LanguageService.getInstance().get(MessageKeys.GAMES_INV_DISABLED).toComponent();
            Players.wrapPlayer(player).sendMessage(disabled);
            return;
        }
        Message couldNotFindGameMessage = LanguageService.getInstance().get(MessageKeys.GAMES_INVENTORY_CANNOT_FIND_GAME);
        Player playerWrapper = Players.wrapPlayer(player);
        List<Game> games = GamesInventory.getInstance().getGamesWithMode(gameMode);
        if (games == null || games.isEmpty()) {
            couldNotFindGameMessage.send(playerWrapper);
            return;
        }
        Random r = new Random();
        games.sort(Comparator.comparing(c -> ((Game)c).getConnectedPlayers().size()).reversed().thenComparing(c -> r.nextInt()));
        games.stream().filter(game -> game.getStatus() == GameStatus.WAITING).findAny().ifPresentOrElse(game -> game.joinToGame(player), () -> couldNotFindGameMessage.send(playerWrapper));
    }

    @CommandMethod(value="sba store open [shop]")
    @CommandDescription(value="open Game store for player")
    @CommandPermission(value="sba.openshop")
    private void sbaGameStoreOpen(@NotNull org.bukkit.entity.Player player, @Argument(value="shop") @NotNull String storeName) {
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game != null) {
            GameStore store = null;
            for (GameStore storeToCompare : game.getGameStores()) {
                if (storeName != null && (storeToCompare.getShopFile() == null || !storeToCompare.getShopFile().equals(storeName))) continue;
                store = storeToCompare;
            }
            if (store != null) {
                final BedwarsOpenShopEvent openShopEvent = new BedwarsOpenShopEvent(game, player, store, null);
                new BukkitRunnable(){

                    public void run() {
                        Bukkit.getServer().getPluginManager().callEvent((Event)openShopEvent);
                    }
                }.runTask((Plugin)SBA.getPluginInstance());
            }
        }
    }

    @CommandMethod(value="sba upgrade")
    @CommandPermission(value="sba.upgrade")
    @CommandDescription(value="upgrade config files")
    private void commandUpgrade(@NotNull CommandSender sender) {
        if (!SBA.getInstance().isPendingUpgrade()) {
            Component cannotExecute = LanguageService.getInstance().get(MessageKeys.COMMAND_CANNOT_EXECUTE).toComponent();
            Players.wrapSender(sender).sendMessage(cannotExecute);
            return;
        }
        SBAConfig.getInstance().upgrade();
        LanguageService.getInstance().load(SBA.getPluginInstance());
        Component upgraded = LanguageService.getInstance().get(MessageKeys.COMMAND_SUCCESSFULLY_UPGRADED).toComponent();
        Players.wrapSender(sender).sendMessage(upgraded);
    }

    @CommandMethod(value="sba updateplugin")
    @CommandPermission(value="sba.updateplugin")
    @CommandDescription(value="upgrade plugin version")
    private void commandUpdatePlugin(@NotNull CommandSender sender) {
        if (!SBA.getInstance().isPendingUpdate()) {
            Component cannotExecute = LanguageService.getInstance().get(MessageKeys.COMMAND_CANNOT_EXECUTE).toComponent();
            Players.wrapSender(sender).sendMessage(cannotExecute);
            return;
        }
        SBA.getInstance().update(sender);
    }

    @CommandMethod(value="sba cancel")
    @CommandDescription(value="cancel configuration upgrades")
    @CommandPermission(value="sba.cancel")
    private void commandCancel(@NotNull CommandSender sender) {
        if (!SBA.getInstance().isPendingUpgrade()) {
            Component m1 = LanguageService.getInstance().get(MessageKeys.CANNOT_DO_COMMAND).toComponent();
            Players.wrapSender(sender).sendMessage(m1);
            return;
        }
        try {
            SBAConfig.getInstance().node("version").set(SBA.getInstance().getVersion());
            SBAConfig.getInstance().saveConfig();
            Component m2 = LanguageService.getInstance().get(MessageKeys.COMMAND_CANCEL_UPGRADE).toComponent();
            Players.wrapSender(sender).sendMessage(m2);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
        }
    }
}

