/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAPlayerPartyInviteDeclineEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartyDeclineCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p decline")
    @CommandPermission(value="sba.party")
    private void commandDecline(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.INVITED_TO_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_INVITED).send(player);
            return;
        }
        PartyManager.getInstance().getInvitedPartyOf(player).ifPresentOrElse(party -> {
            SBAPlayerPartyInviteDeclineEvent partyDeclineEvent = new SBAPlayerPartyInviteDeclineEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)partyDeclineEvent);
            if (partyDeclineEvent.isCancelled()) {
                return;
            }
            party.removeInvitedPlayer(player);
            player.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_DECLINE_OUTGOING).send(player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_DECLINE_INCOMING).replace("%player%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
            if (party.getMembers().size() == 1) {
                PartyManager.getInstance().disband(party.getUUID());
            }
        }, () -> SBA.getInstance().getConfigurator().getStringList("party.message.error").forEach(player::sendMessage));
    }
}

