/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAPlayerPartyLeaveEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.s.CommandSender;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartyLeaveCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p leave")
    @CommandPermission(value="sba.party")
    private void commandLeave(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        SBA.getInstance().getPartyManager().getPartyOf(player).ifPresentOrElse(party -> {
            SBAPlayerPartyLeaveEvent event = new SBAPlayerPartyLeaveEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            player.getSettings().disable(PlayerSetting.IN_PARTY);
            party.removePlayer(player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_OFFLINE_QUIT).replace("%player%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_LEFT).send(player);
            if (party.getMembers().size() == 1) {
                SBA.getInstance().getPartyManager().disband(party.getUUID());
                return;
            }
            if (party.getPartyLeader().equals(player)) {
                party.getMembers().stream().findAny().ifPresentOrElse(member -> {
                    party.setPartyLeader((SBAPlayerWrapper)member);
                    LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_PROMOTED_LEADER).replace("%player%", member.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(player);
                }, () -> SBA.getInstance().getPartyManager().disband(party.getUUID()));
            }
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_OFFLINE_LEFT).replace("%player%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send((CommandSender[])party.getMembers().stream().filter(member -> !player.equals(member)).toArray(SBAPlayerWrapper[]::new));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR));
    }
}

