/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAPlayerPartyMutedEvent;
import io.github.pronze.sba.events.SBAPlayerPartyUnmutedEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.party.PartySetting;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.s.CommandSender;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartySettingsCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p stream")
    @CommandPermission(value="sba.party.public")
    private void commandStream(@NotNull Player playerArg) {
        this.commandOpen(playerArg);
    }

    @CommandMethod(value="stream")
    @CommandPermission(value="sba.party.public")
    private void commandStream2(@NotNull Player playerArg) {
        this.commandOpen(playerArg);
    }

    @CommandMethod(value="party|p open")
    @CommandPermission(value="sba.party.public")
    private void commandOpen(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        Optional<IParty> playerParty = PartyManager.getInstance().getPartyOf(player);
        if (playerParty.isEmpty()) {
            playerParty = PartyManager.getInstance().createParty(player);
        }
        playerParty.ifPresentOrElse(party -> {
            if (!player.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (party.getSettings().getInvite() == PartySetting.Invite.NONE) {
                LanguageService.getInstance().get(MessageKeys.PARTY_WENT_CLOSED).replace("%host%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(player);
                party.getSettings().setInvite(PartySetting.Invite.ALL);
            } else {
                LanguageService.getInstance().get(MessageKeys.PARTY_WENT_OPEN).replace("%host%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(player);
                party.getSettings().setInvite(PartySetting.Invite.NONE);
            }
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }

    @CommandMethod(value="party|p private")
    @CommandPermission(value="sba.party.private")
    private void commandPrivate(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!player.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (party.getSettings().getGamemode() == PartySetting.GameMode.PUBLIC) {
                LanguageService.getInstance().get(MessageKeys.PARTY_WENT_PRIVATE).replace("%host%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(player);
                party.getSettings().setGamemode(PartySetting.GameMode.PRIVATE);
            } else {
                LanguageService.getInstance().get(MessageKeys.PARTY_WENT_PUBLIC).replace("%host%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(player);
                party.getSettings().setGamemode(PartySetting.GameMode.PUBLIC);
            }
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }

    @CommandMethod(value="party|p mute")
    @CommandPermission(value="sba.party")
    private void commandMute(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!player.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (party.getSettings().getChat() == PartySetting.Chat.UNMUTE) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ALREADY_MUTED).replace("%isMuted%", "unmuted").send(player);
            }
            SBAPlayerPartyMutedEvent muteEvent = new SBAPlayerPartyMutedEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)muteEvent);
            if (muteEvent.isCancelled()) {
                return;
            }
            party.getSettings().setChat(PartySetting.Chat.MUTED);
            party.getMembers().forEach(member -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CHAT_ENABLED_OR_DISABLED).replace("%mode%", "muted").send((CommandSender)member));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }

    @CommandMethod(value="party|p unmute")
    @CommandPermission(value="sba.party")
    private void commandUnmute(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!player.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (party.getSettings().getChat() == PartySetting.Chat.MUTED) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ALREADY_MUTED).replace("%isMuted%", "unmuted").send(player);
                return;
            }
            SBAPlayerPartyUnmutedEvent unmuteEvent = new SBAPlayerPartyUnmutedEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)unmuteEvent);
            if (unmuteEvent.isCancelled()) {
                return;
            }
            party.getSettings().setChat(PartySetting.Chat.MUTED);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CHAT_ENABLED_OR_DISABLED).replace("%mode%", "unmuted").send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }
}

