/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.fix;

import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.fix.BaseFix;
import io.github.pronze.sba.utils.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;

public class PerWorldPluginFix
extends BaseFix {
    private boolean isProblematic = false;

    @Override
    public void detect() {
        Plugin PerWorldPlugin = Bukkit.getPluginManager().getPlugin("PerWorldPlugins");
        if (PerWorldPlugin != null) {
            String version = PerWorldPlugin.getDescription().getVersion();
            this.isProblematic = version.startsWith("1.0") || version.startsWith("1.1.0") || version.startsWith("1.1.1") || version.startsWith("1.1.2") || version.startsWith("1.1.3");
        }
    }

    @Override
    public void fix(SBAConfig cfg) {
        if (this.isProblematic) {
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)Main.getInstance());
        }
    }

    @Override
    public void warn() {
        Logger.error("SBA FATAL ERROR::PerWorldPlugins version 1.1.3 or lower breaks custom plugin events required by Bedwars and SBA", new Object[0]);
        Logger.error("SBA Will shutdown due to incompatible plugin(s), You can update PerWorldPlugins to 1.1.4 or higher to fix it", new Object[0]);
    }

    @Override
    public boolean IsProblematic() {
        return this.isProblematic;
    }

    @Override
    public boolean IsCritical() {
        return this.IsProblematic();
    }
}

