/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.sba.AddonAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class GameTierEvent {
    public static final GameTierEvent GAME_END = new GameTierEvent("GameEnd");
    private static List<GameTierEvent> events = new ArrayList<GameTierEvent>();
    private final String key;

    public static void load() {
        List<String> keys = AddonAPI.getInstance().getConfigurator().getSubKeys("upgrades.time");
        events.clear();
        for (String key : keys) {
            GameTierEvent gte = new GameTierEvent(key);
            if (gte.getTime() <= 0) continue;
            events.add(gte);
        }
        events.sort(Comparator.comparing(e -> e.getTime()));
        events.add(GAME_END);
    }

    public static void forceReload() {
        events.clear();
        GameTierEvent.load();
    }

    public static GameTierEvent first() {
        if (events.size() == 0) {
            GameTierEvent.load();
        }
        return events.get(0);
    }

    public int getTime() {
        return AddonAPI.getInstance().getConfigurator().getInt("upgrades.time." + this.key, Integer.MAX_VALUE);
    }

    public static GameTierEvent ofOrdinal(int ordinal) {
        if (ordinal < events.size()) {
            return events.get(ordinal);
        }
        return GAME_END;
    }

    public GameTierEvent getNextEvent() {
        int ordinal = events.indexOf(this);
        return GameTierEvent.ofOrdinal(ordinal + 1);
    }

    public GameTierEvent(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }
}

