/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.IRotatingGenerator;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.game.ItemSpawner;
import sba.sl.h.Hologram;
import sba.sl.h.HologramManager;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;
import sba.sl.t.TaskerTime;
import sba.sl.u.Pair;
import sba.sl.w.Location;

public class RotatingGenerator
implements IRotatingGenerator {
    private org.bukkit.Location location;
    private List<String> lines;
    private int time;
    private int tierLevel = 1;
    private final ItemSpawner itemSpawner;
    private final ItemStack stack;
    private BukkitTask hologramTask;
    private Hologram hologram;

    public RotatingGenerator(ItemSpawner itemSpawner, ItemStack stack, org.bukkit.Location location) {
        this.itemSpawner = itemSpawner;
        this.stack = stack;
        this.location = location;
        this.time = itemSpawner.getItemSpawnerType().getInterval() + 1;
        this.lines = LanguageService.getInstance().get(MessageKeys.ROTATING_GENERATOR_FORMAT).toStringList();
    }

    @Override
    public void spawn(@NotNull List<Player> viewers) {
        Logger.trace("RotatingGenerator::spawn ({},{})", this, viewers);
        double holoHeight = SBAConfig.getInstance().node("floating-generator", "height").getDouble(2.0);
        this.hologram = HologramManager.hologram(Objects.requireNonNull(Location.fromPlatform(this.location.clone().add(0.0, holoHeight, 0.0))));
        this.hologram.item(ItemStackFactory.build(this.stack)).itemPosition(Hologram.ItemPosition.BELOW).rotationMode(Hologram.RotationMode.Y).rotationTime(Pair.of(1, TaskerTime.TICKS));
        this.hologram.show();
        viewers.forEach(player -> this.hologram.addViewer(Players.wrapPlayer(player)));
        this.scheduleTasks();
    }

    @Override
    public void addViewer(@NotNull Player player) {
        if (this.hologram != null) {
            this.hologram.addViewer(Players.wrapPlayer(player));
        }
    }

    @Override
    public void removeViewer(@NotNull Player player) {
        this.hologram.removeViewer(Players.wrapPlayer(player));
    }

    protected void scheduleTasks() {
        SBAUtil.cancelTask(this.hologramTask);
        final boolean resetFullSpawner = Main.getConfigurator().config.getBoolean("reset-full-spawner-countdown-after-picking");
        this.hologramTask = new BukkitRunnable(){

            public void run() {
                boolean full;
                RotatingGenerator.this.hologram.show();
                if (SBA.sbw_0_2_30) {
                    full = RotatingGenerator.this.itemSpawner.getMaxSpawnedResources() <= RotatingGenerator.this.itemSpawner.getSpawnedItemsCount();
                } else {
                    boolean bl = full = RotatingGenerator.this.itemSpawner.getMaxSpawnedResources() <= RotatingGenerator.this.itemSpawner.spawnedItems.size();
                }
                if (!full || !resetFullSpawner) {
                    --RotatingGenerator.this.time;
                }
                List<String> format = !full ? LanguageService.getInstance().get(MessageKeys.ROTATING_GENERATOR_FORMAT).toStringList() : LanguageService.getInstance().get(MessageKeys.ROTATING_GENERATOR_FULL_TEXT_FORMAT).toStringList();
                ArrayList<String> newLines = new ArrayList<String>();
                String matName = RotatingGenerator.this.itemSpawner.getItemSpawnerType().getMaterial() == Material.EMERALD ? "\u00a7a" + LanguageService.getInstance().get(MessageKeys.EMERALD).toString() : "\u00a7b" + LanguageService.getInstance().get(MessageKeys.DIAMOND).toString();
                for (String line : format) {
                    newLines.add(line.replace("%tier%", ShopUtil.romanNumerals.get(RotatingGenerator.this.tierLevel)).replace("%material%", matName + "\u00a76").replace("%seconds%", String.valueOf(RotatingGenerator.this.time)));
                }
                RotatingGenerator.this.update(newLines);
                if (RotatingGenerator.this.time <= 0 || full && resetFullSpawner) {
                    RotatingGenerator.this.time = SBA.sbw_0_2_30 ? RotatingGenerator.this.itemSpawner.currentCycle : RotatingGenerator.this.itemSpawner.getItemSpawnerType().getInterval();
                }
            }
        }.runTaskTimer((Plugin)SBA.getPluginInstance(), 0L, 20L);
    }

    @Override
    public void update(@NotNull List<String> newLines) {
        if (newLines.equals(this.lines)) {
            return;
        }
        for (int i = 0; i < newLines.size(); ++i) {
            this.hologram.replaceLine((Integer)i, Component.text(newLines.get(i)));
        }
        this.lines = new ArrayList<String>(newLines);
    }

    @Override
    public void destroy() {
        Logger.trace("RotatingGenerator::destroy ({})", this);
        SBAUtil.cancelTask(this.hologramTask);
        if (this.hologram != null) {
            this.hologram.destroy();
            this.hologram = null;
        }
    }

    @Override
    public void setLocation(@NotNull org.bukkit.Location location) {
        this.location = location;
    }

    public int getTierLevel() {
        return this.tierLevel;
    }

    public void setTierLevel(int tierLevel) {
        this.tierLevel = tierLevel;
    }

    public ItemSpawner getItemSpawner() {
        return this.itemSpawner;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

