/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game.tasks;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBATeamTrapTriggeredEvent;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.game.tasks.CustomTrap;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.utils.Sounds;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;

public class CustomTrapTask
extends BaseGameTask {
    private final double radius = Math.pow(SBAConfig.getInstance().node("upgrades", "trap-detection-range").getInt(7), 2.0);
    private static Map<String, CustomTrap> knownTraps = new HashMap<String, CustomTrap>();

    @Override
    public void run() {
        this.arena.getGame().getRunningTeams().stream().forEach(team -> this.arena.getStorage().enabledTraps((RunningTeam)team).forEach(trap -> this.arena.getGame().getConnectedPlayers().stream().filter(player -> !Main.getPlayerGameProfile((Player)player).isSpectator).filter(player -> !team.getConnectedPlayers().contains(player)).forEach(player -> {
            if (this.arena.getStorage().getTargetBlockLocation((RunningTeam)team).orElseThrow().distanceSquared(player.getLocation()) <= this.radius) {
                SBATeamTrapTriggeredEvent triggeredEvent = new SBATeamTrapTriggeredEvent((Player)player, (RunningTeam)team, this.arena);
                SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)triggeredEvent);
                if (triggeredEvent.isCancelled()) {
                    return;
                }
                this.arena.getStorage().setPurchasedTrap((RunningTeam)team, false, (String)trap);
                CustomTrap customTrap = knownTraps.get(trap);
                if (customTrap.target.equals("enemy") || customTrap.target.equals("all")) {
                    customTrap.effects.forEach(effect -> player.addPotionEffect(effect));
                }
                if (customTrap.target.equals("team") || customTrap.target.equals("all")) {
                    customTrap.effects.forEach(effect -> team.getConnectedPlayers().forEach(teamPlayer -> teamPlayer.addPotionEffect(effect)));
                }
                if (this.arena.isPlayerHidden((Player)player)) {
                    this.arena.removeHiddenPlayer((Player)player);
                }
                LanguageService.getInstance().get(MessageKeys.TEAM_CUSTOM_TRAP_TRIGGERED_MESSAGE).replace("%trap%", (String)trap).replace("%team%", this.arena.getGame().getTeamOfPlayer(player).getName()).send(Players.wrapPlayer(player).as(SBAPlayerWrapper.class));
                Component title = LanguageService.getInstance().get(MessageKeys.TEAM_CUSTOM_TRAP_TRIGGERED_TITLE).replace("%trap%", (String)trap).toComponent();
                Component subTitle = LanguageService.getInstance().get(MessageKeys.TEAM_CUSTOM_TRAP_TRIGGERED_SUBTITLE).replace("%trap%", (String)trap).toComponent();
                team.getConnectedPlayers().forEach(pl -> {
                    String sound = SBAConfig.getInstance().getString("sounds.on_trap_triggered", "ENTITY_ENDER_DRAGON_GROWL");
                    if (sound == null) {
                        sound = "ENTITY_ENDER_DRAGON_GROWL";
                    }
                    Sounds.playSound((Player)pl, (Location)pl.getLocation(), (String)sound, (Sounds)Sounds.ENTITY_ENDERMAN_TELEPORT, (float)1.0f, (float)1.0f);
                    SBAUtil.sendTitle(Players.wrapPlayer(pl), title, subTitle, 20, 60, 0);
                });
            }
        })));
    }

    public static void registerTrap(CustomTrap trap) {
        knownTraps.put(trap.getIdentifier(), trap);
    }
}

