/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.inventories;

import io.github.pronze.sba.SBA;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.api.game.Game;

public class PlayerTrackerInventory
implements InventoryHolder {
    private Game game;
    private Consumer<Player> targetSelector;
    private List<Player> displayed;
    private String title;

    public PlayerTrackerInventory(Game game, String title, Consumer<Player> targetSelector) {
        this.game = game;
        this.title = title;
        this.targetSelector = targetSelector;
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.PLAYER, (String)this.title);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SBA.getPluginInstance(), () -> this.addContent(inventory));
        return inventory;
    }

    public void onInventoryClick(InventoryClickEvent event) {
        Player target = this.displayed.get(event.getSlot());
        event.getWhoClicked().closeInventory();
        event.setCancelled(true);
        this.targetSelector.accept(target);
    }

    public void addContent(Inventory inventory) {
        int i = 0;
        Material mat = null;
        mat = Material.matchMaterial((String)"PLAYER_HEAD");
        if (mat == null) {
            mat = Material.matchMaterial((String)"SKULL_ITEM");
        }
        this.displayed = this.game != null ? new ArrayList<Player>(this.game.getConnectedPlayers()) : new ArrayList<Player>(Bukkit.getOnlinePlayers());
        for (Player p : this.displayed) {
            if (i >= 36) break;
            ItemStack is = null;
            is = mat.toString() == "SKULL_ITEM" ? new ItemStack(mat, 1, 3) : new ItemStack(mat);
            SkullMeta meta = (SkullMeta)is.getItemMeta();
            meta.setOwner(p.getName());
            meta.setDisplayName(p.getDisplayName());
            is.setItemMeta((ItemMeta)meta);
            inventory.setItem(i++, is);
        }
    }

    public PlayerTrackerInventory openForPlayer(@NotNull Player player) {
        player.openInventory(this.getInventory());
        return this;
    }
}

