/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.party;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.events.SBAPlayerPartyCreatedEvent;
import io.github.pronze.sba.manager.IPartyManager;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.Party;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;

@Service
@ServiceDependencies(dependsOn={Logger.class})
public class PartyManager
implements IPartyManager {
    private final Map<UUID, IParty> partyMap = new HashMap<UUID, IParty>();

    public static PartyManager getInstance() {
        return ServiceManager.get(PartyManager.class);
    }

    @Override
    public Optional<IParty> createParty(@NotNull SBAPlayerWrapper leader) {
        Party party = new Party(leader);
        SBAPlayerPartyCreatedEvent partyCreateEvent = new SBAPlayerPartyCreatedEvent(leader, party);
        SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)partyCreateEvent);
        if (partyCreateEvent.isCancelled()) {
            return Optional.empty();
        }
        this.partyMap.put(party.getUUID(), party);
        return Optional.of(party);
    }

    @Override
    public Optional<IParty> get(@NotNull SBAPlayerWrapper leader) {
        return this.partyMap.values().stream().filter(p -> p.getPartyLeader().equals(leader)).findAny();
    }

    @Override
    public Optional<IParty> get(@NotNull UUID partyUUID) {
        if (!this.partyMap.containsKey(partyUUID)) {
            return Optional.empty();
        }
        return Optional.of(this.partyMap.get(partyUUID));
    }

    @Override
    public Optional<IParty> getOrCreate(@NotNull SBAPlayerWrapper player) {
        return this.getPartyOf(player).or(() -> this.createParty(player));
    }

    @Override
    public Optional<IParty> getPartyOf(@NotNull SBAPlayerWrapper player) {
        return this.partyMap.values().stream().filter(party -> party.getMembers().contains(player)).findAny();
    }

    @Override
    public Optional<IParty> getInvitedPartyOf(@NotNull SBAPlayerWrapper player) {
        return this.partyMap.values().stream().filter(party -> party.isInvited(player)).findAny();
    }

    @Override
    public void disband(@NotNull UUID partyUUID) {
        if (this.partyMap.containsKey(partyUUID)) {
            IParty party = this.partyMap.get(partyUUID);
            this.disband(party);
        }
    }

    @Override
    public void disband(@NotNull SBAPlayerWrapper leader) {
        this.getPartyOf(leader).ifPresent(this::disband);
    }

    private void disband(@NotNull IParty party) {
        Logger.trace("Disbandoning party: {}", party.debugInfo());
        List<String> disbandMessage = SBA.getInstance().getConfigurator().getStringList("party.message.disband");
        party.getMembers().forEach(member -> {
            member.getSettings().disable(PlayerSetting.IN_PARTY);
            party.removePlayer((SBAPlayerWrapper)member);
            SBAPlayerWrapper wrapperImpl = SBA.getInstance().getPlayerWrapper(member.getInstance());
            if (!wrapperImpl.isOnline()) {
                return;
            }
            disbandMessage.forEach(wrapperImpl::sendMessage);
        });
        party.getInvitedPlayers().forEach(invitedPlayer -> {
            invitedPlayer.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
            party.removeInvitedPlayer((SBAPlayerWrapper)invitedPlayer);
            SBAPlayerWrapper wrapperImpl = SBA.getInstance().getPlayerWrapper(invitedPlayer.getInstance());
            if (!wrapperImpl.isOnline()) {
                return;
            }
            SBA.getInstance().getConfigurator().getStringList("party.message.invite-expired").forEach(wrapperImpl::sendMessage);
        });
        party.getInviteData().forEach(data -> {
            BukkitTask inviteTask = data.getInviteTask();
            SBAUtil.cancelTask(inviteTask);
        });
        this.partyMap.remove(party.getUUID());
    }
}

