/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.utils.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.frep.vulcan.api.event.VulcanFlagEvent;
import me.frep.vulcan.api.event.VulcanGhostBlockEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class AntiCheatIntegration
implements Listener {
    ArrayList<Listener> integrations = new ArrayList();
    Set<UUID> currentlyJumping = new HashSet<UUID>();
    Map<UUID, BukkitTask> jumpingCooldown = new HashMap<UUID, BukkitTask>();

    public static AntiCheatIntegration getInstance() {
        return ServiceManager.get(AntiCheatIntegration.class);
    }

    public void beginTntJump(Player p) {
        if (!this.currentlyJumping.contains(p.getUniqueId())) {
            if (this.jumpingCooldown.containsKey(p.getUniqueId())) {
                try {
                    this.jumpingCooldown.get(p.getUniqueId()).cancel();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.jumpingCooldown.remove(p.getUniqueId());
            }
            this.currentlyJumping.add(p.getUniqueId());
            Logger.trace("Starting tnt jump for {}", p);
        }
    }

    public void tntJumpLanding(final Player p) {
        final UUID id = p.getUniqueId();
        this.currentlyJumping.remove(id);
        Logger.trace("Landed tnt jump for {}", p);
        this.jumpingCooldown.put(id, new BukkitRunnable(){

            public void run() {
                AntiCheatIntegration.this.jumpingCooldown.remove(id);
                Logger.trace("Ending tnt jump for {}", p);
            }

            public void cancel() {
                super.cancel();
                Logger.trace("Cancelling delay tnt jump for {}", p);
            }
        }.runTaskLater((Plugin)SBA.getPluginInstance(), 120L));
    }

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Vulcan")) {
            this.integrations.add(new VulcanIntegration());
        }
        this.integrations.forEach(SBA.getInstance()::registerListener);
    }

    private class VulcanIntegration
    implements Listener {
        @EventHandler
        public void onGhostBlock(VulcanGhostBlockEvent event) {
            UUID id = event.getPlayer().getUniqueId();
            if (AntiCheatIntegration.this.currentlyJumping.contains(id) || AntiCheatIntegration.this.jumpingCooldown.containsKey(id)) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onVulcanDetection(VulcanFlagEvent event) {
            Logger.trace("Vulcan detection, [{},{}]", event.getCheck().getDisplayName(), Character.valueOf(event.getCheck().getDisplayType()));
            UUID id = event.getPlayer().getUniqueId();
            if (AntiCheatIntegration.this.currentlyJumping.contains(id) || AntiCheatIntegration.this.jumpingCooldown.containsKey(id) || event.getCheck().getDisplayName().equalsIgnoreCase("Jump")) {
                Logger.trace("Vulcan detection cancelled, {},{},{}", event.getInfo(), event.getCheck().getComplexType(), event.getCheck().getName());
                event.setCancelled(true);
            }
        }
    }
}

