/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils.citizens;

import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.citizens.FakeDeathTrait;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;

public class BuildBedDefenseGoal
implements FakeDeathTrait.AiGoal {
    private final FakeDeathTrait fakeDeathTrait;
    Block bedBlock = null;
    List<Block> blockToBuild = new ArrayList<Block>();

    BuildBedDefenseGoal(FakeDeathTrait fakeDeathTrait) {
        this.fakeDeathTrait = fakeDeathTrait;
    }

    public void floodFill(Block b, int depth) {
        if (depth <= 2) {
            if (!this.blockToBuild.contains(b)) {
                this.blockToBuild.add(b);
            }
            int cost = 1;
            this.floodFill(b.getRelative(BlockFace.EAST), depth + cost);
            this.floodFill(b.getRelative(BlockFace.WEST), depth + cost);
            this.floodFill(b.getRelative(BlockFace.NORTH), depth + cost);
            this.floodFill(b.getRelative(BlockFace.SOUTH), depth + cost);
            this.floodFill(b.getRelative(BlockFace.UP), depth + cost);
        }
    }

    public Block findSecondBedBlock(Block b) {
        for (Block testBlock : List.of(b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.WEST), b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.SOUTH))) {
            Logger.trace("Testing {} for second bed block", testBlock);
            if (!testBlock.getType().toString().toUpperCase().contains("BED")) continue;
            return testBlock;
        }
        return b;
    }

    @Override
    public boolean isAvailable() {
        if (this.fakeDeathTrait.blockPlace() == null) {
            return false;
        }
        this.fakeDeathTrait.blockPlace().getBlock((Inventory)this.fakeDeathTrait.getNpcEntity().getInventory());
        if (this.fakeDeathTrait.blockPlace().isInNeedOfBlock()) {
            return false;
        }
        if (this.bedBlock == null) {
            RunningTeam team;
            Player aiPlayer = (Player)this.fakeDeathTrait.getNPC().getEntity();
            Game g = Main.getInstance().getGameOfPlayer(aiPlayer);
            if (g != null && (team = g.getTeamOfPlayer(aiPlayer)) != null) {
                this.bedBlock = team.getTargetBlock().getBlock();
                this.floodFill(this.bedBlock, 0);
                if (this.bedBlock.getType().toString().toUpperCase().contains("BED")) {
                    this.floodFill(this.findSecondBedBlock(this.bedBlock), 0);
                }
            }
        } else {
            if (this.fakeDeathTrait.blockPlace().isEmpty(this.bedBlock)) {
                return false;
            }
            if (this.blockToBuild.stream().anyMatch(b -> this.fakeDeathTrait.blockPlace().isEmpty((Block)b) && this.fakeDeathTrait.blockPlace().isPlacable(b.getLocation()))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void doGoal() {
        Block toPlace = this.blockToBuild.stream().filter(b -> this.fakeDeathTrait.blockPlace().isEmpty((Block)b) && this.fakeDeathTrait.blockPlace().isPlacable(b.getLocation())).findFirst().orElse(null);
        if (toPlace != null) {
            if (toPlace.getLocation().distance(this.fakeDeathTrait.getNPC().getEntity().getLocation()) < 4.0) {
                this.fakeDeathTrait.blockPlace().placeBlockIfPossible(toPlace.getLocation());
                if (toPlace.getLocation().distance(this.fakeDeathTrait.getNPC().getEntity().getLocation()) < 2.0) {
                    this.fakeDeathTrait.blockPlace().teleport(this.fakeDeathTrait.getNpcEntity(), this.fakeDeathTrait.blockPlace().blockLocation(toPlace.getLocation()).add(0.5, 1.0, 0.5));
                }
            } else {
                this.fakeDeathTrait.getNPC().getNavigator().setTarget(toPlace.getLocation());
            }
        }
    }

    public boolean isOver() {
        return this.blockToBuild.stream().allMatch(b -> !this.fakeDeathTrait.blockPlace().isEmpty((Block)b));
    }
}

