/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.wrapper;

import com.google.common.base.Strings;
import io.github.pronze.sba.AddonAPI;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.Permissions;
import io.github.pronze.sba.data.ToggleableSetting;
import io.github.pronze.sba.wrapper.PlayerSetting;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;
import sba.sl.pa.ExtendablePlayer;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;

public class SBAPlayerWrapper
extends ExtendablePlayer {
    private int shoutCooldown = 0;
    private final ToggleableSetting<PlayerSetting> settings = ToggleableSetting.of(PlayerSetting.class);

    public SBAPlayerWrapper(Player player) {
        super(Players.wrapPlayer(player));
    }

    public void sendMessage(String message) {
        this.getInstance().sendMessage(message);
    }

    public Player getInstance() {
        return this.as(Player.class);
    }

    public boolean canShout() {
        return this.shoutCooldown == 0;
    }

    public void shout(Component message) {
        System.out.println("Player shouting with cooldown " + this.shoutCooldown);
        if (this.shoutCooldown == 0) {
            Collection receivers = Bukkit.getOnlinePlayers();
            if (Main.isPlayerInGame((Player)this.as(Player.class))) {
                receivers = Main.getInstance().getGameOfPlayer(this.as(Player.class)).getConnectedPlayers();
            }
            receivers.forEach(receiver -> Players.wrapPlayer(receiver).sendMessage(message));
            if (this.getInstance().hasPermission(Permissions.SHOUT_BYPASS.getKey()) || SBAPlayerWrapper.getDefaultShoutCoolDownTime() == 0) {
                return;
            }
            this.shoutCooldown = SBAPlayerWrapper.getDefaultShoutCoolDownTime();
            new BukkitRunnable(){

                public void run() {
                    --SBAPlayerWrapper.this.shoutCooldown;
                    if (SBAPlayerWrapper.this.shoutCooldown == 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)AddonAPI.getInstance().getJavaPlugin(), 0L, 20L);
        } else {
            AddonAPI.getInstance().getLanguageService().get(MessageKeys.MESSAGE_SHOUT_WAIT).replace("%seconds%", String.valueOf(this.getShoutCooldown())).send(this);
        }
    }

    public int getXP() {
        PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)this.getInstance());
        if (statistic == null) {
            statistic = Main.getPlayerStatisticsManager().loadStatistic(this.getUuid());
            if (statistic != null) {
                return statistic.getScore();
            }
            return 1;
        }
        return statistic.getScore();
    }

    @Override
    public int getLevel() {
        int xp = this.getXP();
        if (xp < SBAPlayerWrapper.getTotalXPToLevelUp()) {
            return 1;
        }
        return 1 + xp / SBAPlayerWrapper.getTotalXPToLevelUp();
    }

    public String getProgress() {
        int maxLimit = SBAPlayerWrapper.getTotalXPToLevelUp();
        String format = AddonAPI.getInstance().getConfigurator().getString("main-lobby.progress-format", "\u00a7b%progress%\u00a77/\u00a7a%total%").replace("%total%", SBAPlayerWrapper.round(maxLimit));
        int progress = this.getXP() - (this.getLevel() - 1) * maxLimit;
        if (progress <= 0) {
            progress = 0;
        }
        return format.replace("%progress%", SBAPlayerWrapper.round(progress));
    }

    public int getIntegerProgress() {
        return (int)((double)(this.getXP() - (this.getLevel() - 1) * SBAPlayerWrapper.getTotalXPToLevelUp()) / (double)SBAPlayerWrapper.getTotalXPToLevelUp() * 100.0);
    }

    public String getCompletedBoxes() {
        int progress = this.getIntegerProgress();
        if (progress < 1) {
            progress = 1;
        }
        int numberOfBoxesFilled = progress / 10;
        return "&7[&b" + Strings.repeat((String)"\u25a0", (int)numberOfBoxesFilled) + "\u00a77" + Strings.repeat((String)"\u25a0", (int)(10 - numberOfBoxesFilled)) + "&7]";
    }

    protected static String round(double toRound) {
        if (toRound >= 1000.0) {
            BigDecimal bd = new BigDecimal(String.valueOf(toRound / 1000.0));
            bd = bd.setScale(1, RoundingMode.HALF_DOWN);
            return bd.doubleValue() + "k";
        }
        return String.valueOf(toRound);
    }

    protected static String round(int toRound) {
        return SBAPlayerWrapper.round((double)toRound);
    }

    public static int getTotalXPToLevelUp() {
        return AddonAPI.getInstance().getConfigurator().getInt("player-statistics.xp-to-level-up", 5000);
    }

    protected static int getDefaultShoutCoolDownTime() {
        return AddonAPI.getInstance().getConfigurator().getInt("shout.time-out", 60);
    }

    public int getShoutCooldown() {
        return this.shoutCooldown;
    }

    public ToggleableSetting<PlayerSetting> getSettings() {
        return this.settings;
    }

    public void setShoutCooldown(int shoutCooldown) {
        this.shoutCooldown = shoutCooldown;
    }
}

