/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.annotations;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.annotations.AnnotationAccessor;
import sba.cl.annotations.Argument;
import sba.cl.annotations.Flag;
import sba.cl.annotations.injection.ParameterInjectorRegistry;
import sba.cl.arguments.CommandArgument;
import sba.cl.arguments.flags.FlagContext;
import sba.cl.context.CommandContext;
import sba.cl.exceptions.CommandExecutionException;
import sba.cl.execution.CommandExecutionHandler;

public class MethodCommandExecutionHandler<C>
implements CommandExecutionHandler<C> {
    private final CommandMethodContext<C> context;
    private final Parameter[] parameters;
    private final MethodHandle methodHandle;
    private final AnnotationAccessor annotationAccessor;

    public MethodCommandExecutionHandler(@NonNull CommandMethodContext<C> context) throws Exception {
        this.context = context;
        this.methodHandle = MethodHandles.lookup().unreflect(((CommandMethodContext)context).method).bindTo(((CommandMethodContext)context).instance);
        this.parameters = ((CommandMethodContext)context).method.getParameters();
        this.annotationAccessor = AnnotationAccessor.of(((CommandMethodContext)context).method);
    }

    @Override
    public void execute(@NonNull CommandContext<C> commandContext) {
        try {
            this.methodHandle.invokeWithArguments(this.createParameterValues(commandContext, commandContext.flags(), this.parameters));
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandExecutionException(throwable, commandContext);
        }
    }

    protected final List<Object> createParameterValues(CommandContext<C> commandContext, FlagContext flagContext, Parameter[] parameters) {
        ArrayList<Object> arguments = new ArrayList<Object>(parameters.length);
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Argument.class)) {
                Argument argument = parameter.getAnnotation(Argument.class);
                String argumentName = argument.value().equals("__INFERRED_ARGUMENT_NAME__") ? parameter.getName() : argument.value();
                CommandArgument commandArgument = (CommandArgument)((CommandMethodContext)this.context).commandArguments.get(argumentName);
                if (commandArgument.isRequired()) {
                    arguments.add(commandContext.get(argumentName));
                    continue;
                }
                Object optional = commandContext.getOptional(argumentName).orElse(null);
                arguments.add(optional);
                continue;
            }
            if (parameter.isAnnotationPresent(Flag.class)) {
                Flag flag = parameter.getAnnotation(Flag.class);
                if (parameter.getType() == Boolean.TYPE) {
                    arguments.add(flagContext.isPresent(flag.value()));
                    continue;
                }
                arguments.add(flagContext.getValue(flag.value(), null));
                continue;
            }
            if (parameter.getType().isAssignableFrom(commandContext.getSender().getClass())) {
                arguments.add(commandContext.getSender());
                continue;
            }
            Optional<?> value = ((CommandMethodContext)this.context).injectorRegistry.getInjectable(parameter.getType(), commandContext, AnnotationAccessor.of(AnnotationAccessor.of(parameter), this.annotationAccessor));
            if (value.isPresent()) {
                arguments.add(value.get());
                continue;
            }
            throw new IllegalArgumentException(String.format("Could not create value for parameter '%s' of type '%s' in method '%s'", parameter.getName(), parameter.getType().getTypeName(), this.methodHandle.toString()));
        }
        return arguments;
    }

    public @NonNull CommandMethodContext<C> context() {
        return this.context;
    }

    public final @NonNull Parameter @NonNull [] parameters() {
        return this.parameters;
    }

    public final @NonNull MethodHandle methodHandle() {
        return this.methodHandle;
    }

    public final AnnotationAccessor annotationAccessor() {
        return this.annotationAccessor;
    }

    public static class CommandMethodContext<C> {
        private final Object instance;
        private final Map<String, CommandArgument<C, ?>> commandArguments;
        private final Method method;
        private final ParameterInjectorRegistry<C> injectorRegistry;

        CommandMethodContext(@NonNull Object instance, @NonNull Map<@NonNull String, @NonNull CommandArgument<@NonNull C, @NonNull ?>> commandArguments, @NonNull Method method, @NonNull ParameterInjectorRegistry<C> injectorRegistry) {
            this.instance = instance;
            this.commandArguments = commandArguments;
            this.method = method;
            this.method.setAccessible(true);
            this.injectorRegistry = injectorRegistry;
        }

        public @NonNull Object instance() {
            return this.instance;
        }

        public final @NonNull Method method() {
            return this.method;
        }

        public final @NonNull Map<@NonNull String, @NonNull CommandArgument<C, ?>> commandArguments() {
            return this.commandArguments;
        }

        public final @NonNull ParameterInjectorRegistry<C> injectorRegistry() {
            return this.injectorRegistry;
        }
    }
}

