/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.bukkit.parsers.selector;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.ArgumentDescription;
import sba.cl.arguments.CommandArgument;
import sba.cl.arguments.parser.ArgumentParseResult;
import sba.cl.arguments.parser.ArgumentParser;
import sba.cl.bukkit.BukkitCommandContextKeys;
import sba.cl.bukkit.CloudBukkitCapabilities;
import sba.cl.bukkit.arguments.selector.SinglePlayerSelector;
import sba.cl.bukkit.parsers.PlayerArgument;
import sba.cl.bukkit.parsers.selector.SelectorParseException;
import sba.cl.context.CommandContext;
import sba.cl.exceptions.parsing.NoInputProvidedException;

public final class SinglePlayerSelectorArgument<C>
extends CommandArgument<C, SinglePlayerSelector> {
    private SinglePlayerSelectorArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new SinglePlayerSelectorParser(), defaultValue, SinglePlayerSelector.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, SinglePlayerSelector> of(@NonNull String name) {
        return SinglePlayerSelectorArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, SinglePlayerSelector> optional(@NonNull String name) {
        return SinglePlayerSelectorArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, SinglePlayerSelector> optional(@NonNull String name, @NonNull String defaultEntitySelector) {
        return SinglePlayerSelectorArgument.newBuilder(name).asOptionalWithDefault(defaultEntitySelector).build();
    }

    public static final class SinglePlayerSelectorParser<C>
    implements ArgumentParser<C, SinglePlayerSelector> {
        @Override
        public @NonNull ArgumentParseResult<SinglePlayerSelector> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            List entities;
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(SinglePlayerSelectorParser.class, commandContext));
            }
            if (!commandContext.get(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES).contains((Object)CloudBukkitCapabilities.BRIGADIER)) {
                Player player = Bukkit.getPlayer((String)input);
                if (player == null) {
                    return ArgumentParseResult.failure(new PlayerArgument.PlayerParseException(input, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(new SinglePlayerSelector(input, (List<Entity>)ImmutableList.of((Object)player)));
            }
            try {
                entities = Bukkit.selectEntities((CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER), (String)input);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.MALFORMED_SELECTOR, SinglePlayerSelectorParser.class));
            }
            for (Entity e : entities) {
                if (e instanceof Player) continue;
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.NON_PLAYER_IN_PLAYER_SELECTOR, SinglePlayerSelectorParser.class));
            }
            if (entities.size() > 1) {
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.TOO_MANY_PLAYERS, SinglePlayerSelectorParser.class));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(new SinglePlayerSelector(input, entities));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            ArrayList<String> output = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                CommandSender bukkit = commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
                if (bukkit instanceof Player && !((Player)bukkit).canSee(player)) continue;
                output.add(player.getName());
            }
            return output;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, SinglePlayerSelector> {
        private Builder(@NonNull String name) {
            super(SinglePlayerSelector.class, name);
        }

        public @NonNull SinglePlayerSelectorArgument<C> build() {
            return new SinglePlayerSelectorArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

