/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.exceptions;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.Command;
import sba.cl.arguments.CommandArgument;
import sba.cl.exceptions.CommandParseException;

public final class InvalidCommandSenderException
extends CommandParseException {
    private static final long serialVersionUID = 7372142477529875598L;
    private final Class<?> requiredSender;
    private final Command<?> command;

    public InvalidCommandSenderException(@NonNull Object commandSender, @NonNull Class<?> requiredSender, @NonNull List<@NonNull CommandArgument<?, ?>> currentChain) {
        this(commandSender, requiredSender, currentChain, null);
    }

    public InvalidCommandSenderException(@NonNull Object commandSender, @NonNull Class<?> requiredSender, @NonNull List<@NonNull CommandArgument<?, ?>> currentChain, @Nullable Command<?> command) {
        super(commandSender, currentChain);
        this.requiredSender = requiredSender;
        this.command = command;
    }

    public @NonNull Class<?> getRequiredSender() {
        return this.requiredSender;
    }

    @Override
    public String getMessage() {
        return String.format("%s is not allowed to execute that command. Must be of type %s", this.getCommandSender().getClass().getSimpleName(), this.requiredSender.getSimpleName());
    }

    public @Nullable Command<?> getCommand() {
        return this.command;
    }
}

