/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.minecraft.extras;

import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.ArgumentDescription;
import sba.k.a.t.Component;
import sba.k.a.t.ComponentLike;
import sba.k.a.t.serializer.plain.PlainComponentSerializer;
import sba.k.a.translation.GlobalTranslator;

public final class RichDescription
implements ArgumentDescription {
    private static final RichDescription EMPTY = new RichDescription(Component.empty());
    private final Component contents;

    RichDescription(Component contents) {
        this.contents = contents;
    }

    public static @NonNull RichDescription empty() {
        return EMPTY;
    }

    public static @NonNull RichDescription of(@NonNull ComponentLike contents) {
        Component componentContents = Objects.requireNonNull(contents, "contents").asComponent();
        if (Component.empty().equals(componentContents)) {
            return EMPTY;
        }
        return new RichDescription(componentContents);
    }

    public static @NonNull RichDescription translatable(@NonNull String key) {
        Objects.requireNonNull(key, "key");
        return new RichDescription(Component.translatable(key));
    }

    public static @NonNull RichDescription translatable(@NonNull String key, ComponentLike ... args) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(args, "args");
        return new RichDescription(Component.translatable(key, args));
    }

    @Override
    @Deprecated
    public @NonNull String getDescription() {
        return PlainComponentSerializer.plain().serialize(GlobalTranslator.render(this.contents, Locale.getDefault()));
    }

    public @NonNull Component getContents() {
        return this.contents;
    }

    @Override
    public boolean isEmpty() {
        return Component.empty().equals(this.contents);
    }
}

