/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.paper;

import com.destroystokyo.paper.brigadier.BukkitBrigadierCommandSource;
import com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.CommandTree;
import sba.cl.brigadier.CloudBrigadierManager;
import sba.cl.bukkit.BukkitBrigadierMapper;
import sba.cl.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import sba.cl.context.CommandContext;
import sba.cl.paper.PaperBrigadierMapper;
import sba.cl.paper.PaperCommandManager;
import sba.cl.permission.CommandPermission;

class PaperBrigadierListener<C>
implements Listener {
    private final CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager;
    private final PaperCommandManager<C> paperCommandManager;

    PaperBrigadierListener(@NonNull PaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
        this.brigadierManager = new CloudBrigadierManager(this.paperCommandManager, () -> new CommandContext(this.paperCommandManager.getCommandSenderMapper().apply((CommandSender)Bukkit.getConsoleSender()), this.paperCommandManager));
        this.brigadierManager.brigadierSenderMapper(sender -> this.paperCommandManager.getCommandSenderMapper().apply(sender.getBukkitSender()));
        new PaperBrigadierMapper<C>(new BukkitBrigadierMapper<C>(this.paperCommandManager, this.brigadierManager));
        this.brigadierManager.backwardsBrigadierSenderMapper(new BukkitBackwardsBrigadierSenderMapper(this.paperCommandManager));
    }

    protected @NonNull CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager() {
        return this.brigadierManager;
    }

    @EventHandler
    public void onCommandRegister(@NonNull CommandRegisteredEvent<BukkitBrigadierCommandSource> event) {
        CommandTree.Node node;
        if (!(event.getCommand() instanceof PluginIdentifiableCommand)) {
            return;
        }
        if (!((PluginIdentifiableCommand)event.getCommand()).getPlugin().equals(this.paperCommandManager.getOwningPlugin())) {
            return;
        }
        CommandTree commandTree = this.paperCommandManager.getCommandTree();
        String label = event.getCommandLabel();
        if (label.contains(":")) {
            label = label.split(Pattern.quote(":"))[1];
        }
        if ((node = commandTree.getNamedNode(label)) == null) {
            return;
        }
        BiPredicate<BukkitBrigadierCommandSource, CommandPermission> permissionChecker = (s, p) -> {
            Object sender = this.paperCommandManager.getCommandSenderMapper().apply(s.getBukkitSender());
            return this.paperCommandManager.hasPermission(sender, (CommandPermission)p);
        };
        event.setLiteral(this.brigadierManager.createLiteralCommandNode(node, (LiteralCommandNode<BukkitBrigadierCommandSource>)event.getLiteral(), (SuggestionProvider<BukkitBrigadierCommandSource>)event.getBrigadierCommand(), (Command<BukkitBrigadierCommandSource>)event.getBrigadierCommand(), permissionChecker));
    }
}

