/*
 * Decompiled with CFR 0.152.
 */
package sba.si.builder;

import lombok.NonNull;
import sba.si.builder.AbstractQueueBuilder;
import sba.si.builder.LocalOptionsBuilder;
import sba.si.inventory.InventorySet;
import sba.si.inventory.Queueable;
import sba.si.inventory.SubInventory;
import sba.sl.u.ReceiverConsumer;

public class CategoryBuilder
extends AbstractQueueBuilder<CategoryBuilder> {
    protected SubInventory subInventory;

    @Override
    protected InventorySet getFormat() {
        return this.getSubInventory().getInventorySet();
    }

    @Override
    protected void putObjectToQueue(@NonNull Queueable queueable) {
        if (queueable == null) {
            throw new NullPointerException("queueable is marked non-null but is null");
        }
        this.getSubInventory().putIntoQueue(queueable);
    }

    public CategoryBuilder categoryOptions(ReceiverConsumer<LocalOptionsBuilder> consumer) {
        consumer.accept(this.getCategoryOptions());
        return this;
    }

    public LocalOptionsBuilder getCategoryOptions() {
        return LocalOptionsBuilder.of(this.getSubInventory().getLocalOptions());
    }

    public SubInventory process() {
        this.getSubInventory().process();
        return this.getSubInventory();
    }

    public SubInventory getSubInventory() {
        return this.subInventory;
    }

    protected CategoryBuilder() {
    }

    private CategoryBuilder(SubInventory subInventory) {
        this.subInventory = subInventory;
    }

    public static CategoryBuilder of(SubInventory subInventory) {
        return new CategoryBuilder(subInventory);
    }
}

