/*
 * Decompiled with CFR 0.152.
 */
package sba.si.bukkit.action;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import sba.si.action.ClickActionHandler;
import sba.si.bukkit.SimpleInventoriesBukkit;
import sba.si.bukkit.holder.AbstractHolder;
import sba.si.bukkit.render.BukkitInventoryRenderer;
import sba.si.bukkit.utils.InventoryUtils;
import sba.sl.pa.Players;
import sba.sl.u.ClickType;

public class BukkitClickActionHandler
extends ClickActionHandler
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled() || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory primaryInventory = event.getInventory();
        InventoryHolder possibleHolder = InventoryUtils.getInventoryHolderWithoutSnapshot(primaryInventory);
        if (possibleHolder instanceof AbstractHolder) {
            Player player = (Player)event.getWhoClicked();
            BukkitInventoryRenderer inventoryRenderer = ((AbstractHolder)possibleHolder).getInventoryRenderer();
            if (!inventoryRenderer.getPlayer().equals(Players.wrapPlayer(player))) {
                event.setCancelled(true);
                return;
            }
            Inventory inventory = InventoryUtils.getInventory(event.getView(), event.getRawSlot());
            if (!primaryInventory.equals(inventory)) {
                if (event.getClick().isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction()) {
                    event.setCancelled(true);
                }
                return;
            }
            event.setCancelled(true);
            this.handleAction(inventoryRenderer, event.getSlot(), ClickType.convert(event.getClick().name()));
        }
    }

    @Override
    protected void dispatchPlayerCommand(sba.sl.pa.Player playerWrapper, String command) {
        playerWrapper.as(Player.class).performCommand(command);
    }

    @Override
    protected void dispatchConsoleCommand(String command) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    @Override
    protected void movePlayerOnProxy(sba.sl.pa.Player playerWrapper, String server) {
        if (!Bukkit.getMessenger().getOutgoingChannels(SimpleInventoriesBukkit.getPlugin()).contains("BungeeCord")) {
            Bukkit.getMessenger().registerOutgoingPluginChannel(SimpleInventoriesBukkit.getPlugin(), "BungeeCord");
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(server);
        playerWrapper.as(Player.class).sendPluginMessage(SimpleInventoriesBukkit.getPlugin(), "BungeeCord", out.toByteArray());
    }
}

