/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface ComponentHolder
extends Wrapper {
    @NotNull
    public static ComponentHolder of(@NotNull Object component) {
        ComponentHolder result = ComponentHolder.ofNullable(component);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap component: " + String.valueOf(component));
        }
        return result;
    }

    @Nullable
    public static ComponentHolder ofNullable(@Nullable Object component) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + ComponentHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (component == null) {
            return null;
        }
        return Provider.provider.apply(component);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable ComponentHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable ComponentHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + ComponentHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

