/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface ChunkHolder
extends Wrapper {
    @NotNull
    public static ChunkHolder of(@NotNull Object chunk) {
        ChunkHolder result = ChunkHolder.ofNullable(chunk);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap chunk: " + String.valueOf(chunk));
        }
        return result;
    }

    @Nullable
    public static ChunkHolder ofNullable(@Nullable Object chunk) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + ChunkHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (chunk == null) {
            return null;
        }
        return Provider.provider.apply(chunk);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable ChunkHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable ChunkHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + ChunkHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

