/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
@ApiStatus.Experimental
public interface ContainerHolder
extends Wrapper {
    @NotNull
    public static ContainerHolder of(@NotNull Object container) {
        ContainerHolder result = ContainerHolder.ofNullable(container);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap container: " + String.valueOf(container));
        }
        return result;
    }

    @Nullable
    public static ContainerHolder ofNullable(@Nullable Object container) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + ContainerHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (container == null) {
            return null;
        }
        return Provider.provider.apply(container);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable ContainerHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable ContainerHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + ContainerHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

