/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface ItemStackHolder
extends Wrapper {
    @NotNull
    public static ItemStackHolder of(@NotNull Object itemStack) {
        ItemStackHolder result = ItemStackHolder.ofNullable(itemStack);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap item stack: " + String.valueOf(itemStack));
        }
        return result;
    }

    @Nullable
    public static ItemStackHolder ofNullable(@Nullable Object itemStack) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + ItemStackHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (itemStack == null) {
            return null;
        }
        return Provider.provider.apply(itemStack);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable ItemStackHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable ItemStackHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + ItemStackHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

