/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface ItemTypeHolder
extends Wrapper {
    @NotNull
    public static ItemTypeHolder of(@NotNull Object itemType) {
        ItemTypeHolder result = ItemTypeHolder.ofNullable(itemType);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap item type: " + String.valueOf(itemType));
        }
        return result;
    }

    @Nullable
    public static ItemTypeHolder ofNullable(@Nullable Object itemType) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + ItemTypeHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (itemType == null) {
            return null;
        }
        return Provider.provider.apply(itemType);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable ItemTypeHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable ItemTypeHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + ItemTypeHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

