/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface WorldHolder
extends Wrapper {
    @NotNull
    public static WorldHolder of(@NotNull Object world) {
        WorldHolder result = WorldHolder.ofNullable(world);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap world: " + String.valueOf(world));
        }
        return result;
    }

    @Nullable
    public static WorldHolder ofNullable(@Nullable Object world) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + WorldHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (world == null) {
            return null;
        }
        return Provider.provider.apply(world);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable WorldHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable WorldHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + WorldHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

