/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.b;

import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.TaggableHolder;
import sba.sl.api.types.server.BlockHolder;
import sba.sl.impl.block.BlockRegistry;
import sba.sl.pa.ParticleData;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface Block
extends RegistryItem,
ParticleData,
TaggableHolder,
BlockHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @NotNull
    public @Unmodifiable @NotNull Map<@NotNull String, String> stateData();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Block withStateData(@NotNull @NotNull Map<@NotNull String, String> var1);

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public Block with(@NotNull String var1, @NotNull String var2);

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public Block with(@NotNull String var1, int var2);

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public Block with(@NotNull String var1, boolean var2);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public Block colorize(@NotNull String color) {
        return BlockRegistry.colorize(this, color);
    }

    @Nullable
    public String get(@NotNull String var1);

    @Nullable
    public Integer getInt(@NotNull String var1);

    @Nullable
    public Boolean getBoolean(@NotNull String var1);

    default public boolean isAir() {
        return this.isSameType(Block.air(), "minecraft:cave_air", "minecraft:void_air");
    }

    public boolean isSolid();

    public boolean isTransparent();

    public boolean isFlammable();

    public boolean isBurnable();

    public boolean isOccluding();

    public boolean hasGravity();

    @Override
    public boolean hasTag(@MinecraftType(value=MinecraftType.Type.BLOCK_TYPE_TAG) @NotNull Object var1);

    public boolean isSameType(@MinecraftType(value=MinecraftType.Type.BLOCK_TYPE) @Nullable Object var1);

    public boolean isSameType(Object ... var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.BLOCK_OR_TAG) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public String completeState();

    @NotNull
    public static Block of(@MinecraftType(value=MinecraftType.Type.BLOCK) @NotNull Object type) {
        Block result = Block.ofNullable(type);
        Preconditions.checkNotNullIllegal(result, "Could not find block type: " + String.valueOf(type));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Block ofNullable(@MinecraftType(value=MinecraftType.Type.BLOCK) @Nullable Object type) {
        if (type instanceof Block) {
            return (Block)type;
        }
        return (Block)BlockRegistry.getInstance().resolveMapping(type);
    }

    @NotNull
    public static Block air() {
        return BlockRegistry.getCachedAir();
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull Block> all() {
        return BlockRegistry.getInstance().getRegistryItemStream();
    }
}

