/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.b;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.BlockPlacementHolder;
import sba.sl.b.BlockPlacement;
import sba.sl.impl.block.BlockRegistry;
import sba.sl.impl.world.Locations;
import sba.sl.u.BidirectionalConverter;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.w.Location;

@ProvidedService
@ServiceDependencies(dependsOn={Locations.class, BlockRegistry.class})
public abstract class BlockPlacements {
    @NotNull
    protected final BidirectionalConverter<BlockPlacement> converter = BidirectionalConverter.build().registerP2W(BlockPlacement.class, e -> e).registerP2W(Location.class, this::getBlockAt0);
    @Nullable
    private static BlockPlacements mapping;

    @ApiStatus.Internal
    public BlockPlacements() {
        Preconditions.checkArgument(mapping == null, "BlockPlacements is already initialized!");
        mapping = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static BlockPlacement resolve(@Nullable Object obj) {
        return Preconditions.checkNotNull(BlockPlacements.mapping, (Object)"BlockPlacements is not initialized yet!").converter.convertNullable(obj);
    }

    @NotNull
    public static BlockPlacement getBlockAt(@NotNull Location location) {
        return Preconditions.checkNotNull(mapping, "BlockPlacements is not initialized yet!").getBlockAt0(location);
    }

    @NotNull
    protected abstract BlockPlacement getBlockAt0(@NotNull Location var1);

    static {
        BlockPlacementHolder.Provider.registerProvider(o -> Objects.requireNonNull(BlockPlacements.resolve(o), "Cannot convert " + String.valueOf(o) + " to BlockPlacement"));
    }
}

