/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.co;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.sl.Server;
import sba.sl.a.AttributeModifier;
import sba.sl.u.ResourceLocation;

public class AttributeModifierSerializer
implements TypeSerializer<AttributeModifier> {
    @NotNull
    private static final String ID_KEY = "id";
    @NotNull
    private static final String UUID_KEY = "uuid";
    @NotNull
    private static final String NAME_KEY = "name";
    @NotNull
    private static final String AMOUNT_KEY = "amount";
    @NotNull
    private static final String OPERATION_KEY = "operation";
    @NotNull
    public static final AttributeModifierSerializer INSTANCE = new AttributeModifierSerializer();

    @Override
    @NotNull
    public AttributeModifier deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        try {
            ConfigurationNode id = node.node(ID_KEY);
            ConfigurationNode uuid = node.node(UUID_KEY);
            ConfigurationNode name = node.node(NAME_KEY);
            ConfigurationNode amount = node.node(AMOUNT_KEY);
            ConfigurationNode operation = node.node(OPERATION_KEY);
            if (!id.empty()) {
                return new AttributeModifier(ResourceLocation.of(id.getString("")), amount.getDouble(), AttributeModifierSerializer.read(operation.getString(""), AttributeModifier.Operation.ADD_VALUE));
            }
            return new AttributeModifier(uuid.get(UUID.class, UUID::randomUUID), name.getString(""), amount.getDouble(), AttributeModifierSerializer.read(operation.getString(""), AttributeModifier.Operation.ADD_VALUE));
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable AttributeModifier obj, @NotNull ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        if (Server.isVersion(1, 21)) {
            node.node(ID_KEY).set(obj.getLocation().toString());
        } else {
            node.node(UUID_KEY).set(obj.getUuid());
            node.node(NAME_KEY).set(obj.getName());
        }
        node.node(AMOUNT_KEY).set(obj.getAmount());
        node.node(OPERATION_KEY).set((Object)obj.getOperation());
    }

    public static @NotNull AttributeModifier.Operation read(@NotNull String operation, @NotNull AttributeModifier.Operation defaultVal) {
        switch (operation.toLowerCase(Locale.ROOT)) {
            case "addition": 
            case "add_value": {
                return AttributeModifier.Operation.ADD_VALUE;
            }
            case "multiply_base": 
            case "add_multiplied_base": {
                return AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
            }
            case "multiply_total": 
            case "add_multiplied_total": {
                return AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
            }
        }
        return defaultVal;
    }
}

