/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.co;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.sl.f.FireworkEffect;
import sba.sl.spectator.Color;

public class FireworkEffectSerializer
implements TypeSerializer<FireworkEffect> {
    @NotNull
    private static final String TYPE_KEY = "type";
    @NotNull
    private static final String FLICKER_KEY = "flicker";
    @NotNull
    private static final String TRAIL_KEY = "trail";
    @NotNull
    private static final String COLORS_KEY = "colors";
    @NotNull
    private static final String FADE_COLORS_KEY = "fade-colors";
    @NotNull
    public static final FireworkEffectSerializer INSTANCE = new FireworkEffectSerializer();

    @Override
    @NotNull
    public FireworkEffect deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        try {
            Color color;
            if (!node.isMap()) {
                return FireworkEffect.of(node.getString());
            }
            ConfigurationNode effectNode = node.node(TYPE_KEY);
            ConfigurationNode flickerNode = node.node(FLICKER_KEY);
            ConfigurationNode trailNode = node.node(TRAIL_KEY);
            ConfigurationNode colorsNode = node.node(COLORS_KEY);
            ConfigurationNode fadeColorsNode = node.node(FADE_COLORS_KEY);
            FireworkEffect holder = FireworkEffect.of(effectNode.getString()).withFlicker(flickerNode.getBoolean(true)).withTrail(trailNode.getBoolean(true));
            if (!colorsNode.empty()) {
                if (colorsNode.isList()) {
                    holder = holder.withColors(colorsNode.childrenList().stream().map(this::deserializeColor).filter(Objects::nonNull).collect(Collectors.toList()));
                } else {
                    color = this.deserializeColor(colorsNode);
                    if (color != null) {
                        holder = holder.withColors(List.of(color));
                    }
                }
            }
            if (!fadeColorsNode.empty()) {
                if (fadeColorsNode.isList()) {
                    holder = holder.withFadeColors(fadeColorsNode.childrenList().stream().map(this::deserializeColor).filter(Objects::nonNull).collect(Collectors.toList()));
                } else {
                    color = this.deserializeColor(fadeColorsNode);
                    if (color != null) {
                        holder = holder.withFadeColors(List.of(color));
                    }
                }
            }
            return holder;
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable FireworkEffect obj, @NotNull ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.node(TYPE_KEY).set(obj.type().location().asString());
        node.node(FLICKER_KEY).set(obj.flicker());
        node.node(TRAIL_KEY).set(obj.trail());
        for (Color color : obj.colors()) {
            node.node(COLORS_KEY).appendListNode().set(Color.class, color);
        }
        for (Color color : obj.fadeColors()) {
            node.node(FADE_COLORS_KEY).appendListNode().set(Color.class, color);
        }
    }

    @Nullable
    protected Color deserializeColor(@NotNull ConfigurationNode colorNode) {
        try {
            return colorNode.get(Color.class);
        }
        catch (SerializationException ex) {
            return Color.WHITE;
        }
    }
}

