/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.e.pose;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.entity.pose.EntityPoseRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

@LimitedVersionSupport(value="Bukkit >= 1.17")
public interface EntityPose
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.ENTITY_POSE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static EntityPose of(@MinecraftType(value=MinecraftType.Type.ENTITY_POSE) @NotNull Object entityPose) {
        EntityPose result = EntityPose.ofNullable(entityPose);
        Preconditions.checkNotNullIllegal(result, "Could not find entity pose: " + String.valueOf(entityPose));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static EntityPose ofNullable(@MinecraftType(value=MinecraftType.Type.ENTITY_POSE) @Nullable Object entityPose) {
        if (entityPose instanceof EntityPose) {
            return (EntityPose)entityPose;
        }
        return (EntityPose)EntityPoseRegistry.getInstance().resolveMapping(entityPose);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull EntityPose> all() {
        return EntityPoseRegistry.getInstance().getRegistryItemStream();
    }
}

