/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.h;

import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Core;
import sba.sl.ev.EventManager;
import sba.sl.h.Hologram;
import sba.sl.h.HologramImpl;
import sba.sl.h.event.HologramTouchEvent;
import sba.sl.p.PacketMapper;
import sba.sl.pa.Player;
import sba.sl.u.InteractType;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.vi.AbstractVisualsManager;
import sba.sl.w.Location;

@Service
@ServiceDependencies(dependsOn={Core.class, PacketMapper.class})
public class HologramManager
extends AbstractVisualsManager<Hologram> {
    @Nullable
    private static HologramManager manager;
    private static boolean preferDisplayEntities;

    public HologramManager() {
        if (manager != null) {
            throw new UnsupportedOperationException("HologramManager is already initialized");
        }
        manager = this;
    }

    @NotNull
    public static Hologram hologram(@NotNull Location holder) {
        return HologramManager.hologram(UUID.randomUUID(), holder, false);
    }

    @NotNull
    public static Hologram hologram(@NotNull Location holder, boolean touchable) {
        return HologramManager.hologram(UUID.randomUUID(), holder, touchable);
    }

    @NotNull
    public static Hologram hologram(@NotNull UUID uuid, @NotNull Location holder) {
        return HologramManager.hologram(uuid, holder, false);
    }

    @NotNull
    public static Hologram hologram(@NotNull UUID uuid, @NotNull Location holder, boolean touchable) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        HologramImpl hologram = new HologramImpl(uuid, holder, touchable);
        HologramManager.addHologram(hologram);
        return hologram;
    }

    @NotNull
    public static @NotNull Map<@NotNull UUID, Hologram> getActiveHolograms() {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        return manager.getActiveVisuals();
    }

    @Contract(value="null -> null")
    @Nullable
    public static Hologram getHologram(@Nullable UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        return HologramManager.getActiveHolograms().get(uuid);
    }

    public static void addHologram(@NotNull Hologram hologram) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        manager.addVisual(hologram.uuid(), hologram);
    }

    public static void removeHologram(@Nullable UUID uuid) {
        Hologram hologram = HologramManager.getHologram(uuid);
        if (hologram != null) {
            HologramManager.removeHologram(hologram);
        }
    }

    public static void removeHologram(@NotNull Hologram hologram) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        manager.removeVisual(hologram.uuid());
    }

    @Override
    public void fireVisualTouchEvent(@NotNull Player sender, @NotNull Hologram visual, @NotNull InteractType interactType) {
        EventManager.fireAsync(new HologramTouchEvent(sender, visual, interactType));
    }

    @Generated
    public static boolean isPreferDisplayEntities() {
        return preferDisplayEntities;
    }

    @Generated
    public static void setPreferDisplayEntities(boolean preferDisplayEntities) {
        HologramManager.preferDisplayEntities = preferDisplayEntities;
    }

    static {
        preferDisplayEntities = true;
    }
}

