/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.hi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import sba.sl.e.HumanEntity;
import sba.sl.hi.HealthIndicator2;
import sba.sl.hi.HealthIndicatorManager2;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundSetDisplayObjectivePacket;
import sba.sl.p.ClientboundSetObjectivePacket;
import sba.sl.p.ClientboundSetScorePacket;
import sba.sl.pa.Player;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.t.task.Task;
import sba.sl.u.data.DataContainer;
import sba.sl.vi.UpdateStrategy;
import sba.sl.vi.impl.AbstractVisual;

public class HealthIndicatorImpl2
extends AbstractVisual<HealthIndicator2>
implements HealthIndicator2 {
    private final String underNameTagKey;
    private final String tabListKey;
    private final ConcurrentSkipListMap<String, Integer> values = new ConcurrentSkipListMap();
    protected final List<Player> trackedPlayers = new LinkedList<Player>();
    protected DataContainer data;
    protected volatile boolean ready;
    protected volatile boolean healthInTabList;
    protected volatile Component symbol = Component.empty();
    protected Task task;
    private static Function<Player, String> nameProvider;

    public HealthIndicatorImpl2(UUID uuid) {
        super(uuid);
        this.underNameTagKey = HealthIndicatorImpl2.generateObjectiveKey();
        this.tabListKey = HealthIndicatorImpl2.generateObjectiveKey();
    }

    @Override
    public HealthIndicator2 addTrackedPlayer(Player player) {
        if (!this.trackedPlayers.contains(player)) {
            this.trackedPlayers.add(player);
            if (this.visible && this.ready && this.task == null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public HealthIndicator2 removeTrackedPlayer(Player player) {
        if (this.trackedPlayers.contains(player)) {
            this.trackedPlayers.remove(player);
            if (this.visible && this.ready && this.task == null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public HealthIndicator2 symbol(ComponentLike symbol) {
        return this.symbol(symbol.asComponent());
    }

    @Override
    public HealthIndicator2 showHealthInTabList(boolean flag) {
        this.healthInTabList = flag;
        return this;
    }

    @Override
    public HealthIndicator2 symbol(Component symbol) {
        this.symbol = symbol;
        if (this.visible && this.ready) {
            this.updateSymbol0();
        }
        return this;
    }

    @Override
    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        return !this.data.isEmpty();
    }

    public static void setNameProvider(Function<Player, String> nFunction) {
        nameProvider = nFunction;
    }

    private String getName(Player p) {
        if (nameProvider != null) {
            return nameProvider.apply(p);
        }
        return p.getName();
    }

    @Override
    public HealthIndicator2 update(UpdateStrategy strategy) {
        if (this.ready) {
            ArrayList<AbstractPacket> packets = new ArrayList<AbstractPacket>();
            List<Player> trackedPlayers = List.copyOf(this.trackedPlayers);
            List.copyOf(this.values.keySet()).stream().filter(s -> trackedPlayers.stream().noneMatch(p -> this.getName((Player)p).equals(s))).forEach(s -> {
                this.values.remove(s);
                packets.add(this.getDestroyScorePacket((String)s).objectiveKey(this.underNameTagKey).build());
                if (this.healthInTabList) {
                    packets.add(this.getDestroyScorePacket((String)s).objectiveKey(this.tabListKey).build());
                }
            });
            trackedPlayers.forEach(playerWrapper -> {
                if (!playerWrapper.isOnline()) {
                    this.removeViewer((Player)playerWrapper);
                    return;
                }
                int health = (int)Math.round(playerWrapper.as(HumanEntity.class).getHealth());
                String key = this.getName((Player)playerWrapper);
                if (!this.values.containsKey(key) || this.values.get(key) != health) {
                    this.values.put(key, health);
                    packets.add(this.createScorePacket(key, health).objectiveKey(this.underNameTagKey).build());
                    if (this.healthInTabList) {
                        packets.add(this.createScorePacket(key, health).objectiveKey(this.tabListKey).build());
                    }
                }
            });
            packets.forEach(packet -> packet.sendPacket(this.viewers));
        } else {
            this.viewers.forEach(viewer -> this.onViewerRemoved((Player)viewer, false));
        }
        return this;
    }

    @Override
    public HealthIndicator2 show() {
        this.ready = true;
        this.visible = true;
        this.viewers.forEach(a -> this.onViewerAdded((Player)a, false));
        this.update();
        return this;
    }

    @Override
    public HealthIndicator2 hide() {
        this.visible = false;
        this.ready = false;
        this.update();
        return this;
    }

    @Override
    public void destroy() {
        this.data = null;
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.hide();
        this.viewers.clear();
        this.trackedPlayers.clear();
        this.values.clear();
        HealthIndicatorManager2.removeHealthIndicator(this);
    }

    @Override
    public HealthIndicator2 startUpdateTask(long time, TaskerTime unit) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Tasker.runAsyncRepeatedly(() -> this.update(), time, unit);
        return this;
    }

    protected void updateSymbol0() {
        if (this.visible) {
            this.getUpdateObjectivePacket().objectiveKey(this.underNameTagKey).build().sendPacket(this.viewers);
            if (this.healthInTabList) {
                this.getUpdateObjectivePacket().objectiveKey(this.tabListKey).build().sendPacket(this.viewers);
            }
        }
    }

    @Override
    public void onViewerAdded(Player player, boolean checkDistance) {
        if (this.visible) {
            this.getCreateObjectivePacket().objectiveKey(this.underNameTagKey).build().sendPacket(player);
            ClientboundSetDisplayObjectivePacket.builder().objectiveKey(this.underNameTagKey).slot(ClientboundSetDisplayObjectivePacket.DisplaySlot.BELOW_NAME).build().sendPacket(player);
            this.values.forEach((s, integer) -> this.createScorePacket((String)s, (int)integer).objectiveKey(this.underNameTagKey).build().sendPacket(player));
            if (this.healthInTabList) {
                this.getCreateObjectivePacket().objectiveKey(this.tabListKey).build().sendPacket(player);
                ClientboundSetDisplayObjectivePacket.builder().objectiveKey(this.tabListKey).slot(ClientboundSetDisplayObjectivePacket.DisplaySlot.PLAYER_LIST).build().sendPacket(player);
                this.values.forEach((s, integer) -> this.createScorePacket((String)s, (int)integer).objectiveKey(this.tabListKey).build().sendPacket(player));
            }
        }
    }

    @Override
    public void onViewerRemoved(Player player, boolean checkDistance) {
        this.getDestroyObjectivePacket().objectiveKey(this.underNameTagKey).build().sendPacket(player);
        if (this.healthInTabList) {
            this.getDestroyObjectivePacket().objectiveKey(this.tabListKey).build().sendPacket(player);
        }
    }

    private ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder getNotFinalObjectivePacket() {
        return ClientboundSetObjectivePacket.builder().title(this.symbol.asComponent()).criteriaType(ClientboundSetObjectivePacket.Type.INTEGER);
    }

    private ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder getCreateObjectivePacket() {
        ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder packet = this.getNotFinalObjectivePacket();
        packet.mode(ClientboundSetObjectivePacket.Mode.CREATE);
        return packet;
    }

    private ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder getUpdateObjectivePacket() {
        ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder packet = this.getNotFinalObjectivePacket();
        packet.mode(ClientboundSetObjectivePacket.Mode.UPDATE);
        return packet;
    }

    private ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder getDestroyObjectivePacket() {
        return ClientboundSetObjectivePacket.builder().mode(ClientboundSetObjectivePacket.Mode.DESTROY);
    }

    private ClientboundSetScorePacket.ClientboundSetScorePacketBuilder createScorePacket(String key, int score) {
        return ClientboundSetScorePacket.builder().entityName(key).score(score).action(ClientboundSetScorePacket.ScoreboardAction.CHANGE);
    }

    private ClientboundSetScorePacket.ClientboundSetScorePacketBuilder getDestroyScorePacket(String key) {
        return ClientboundSetScorePacket.builder().entityName(key).action(ClientboundSetScorePacket.ScoreboardAction.REMOVE);
    }

    private static String generateObjectiveKey() {
        return new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    public DataContainer data() {
        return this.data;
    }

    @Override
    public HealthIndicatorImpl2 data(DataContainer data) {
        this.data = data;
        return this;
    }
}

