/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.a.ItemAttribute;
import sba.sl.api.types.server.ItemStackHolder;
import sba.sl.i.HideFlags;
import sba.sl.i.ItemType;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.i.data.ItemData;
import sba.sl.i.meta.Enchantment;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.CompoundTagHolder;
import sba.sl.nbt.CompoundTagLike;
import sba.sl.nbt.CompoundTagTreeInspector;
import sba.sl.nbt.Tag;
import sba.sl.nbt.TreeInspectorKey;
import sba.sl.pa.ParticleData;
import sba.sl.spectator.Component;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.spectator.event.hover.ItemContentLike;
import sba.sl.u.ComparableWrapper;
import sba.sl.u.RawValueHolder;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.u.annotations.ide.MinecraftType;

public interface ItemStack
extends ComparableWrapper,
RawValueHolder,
ParticleData,
Cloneable,
CompoundTagHolder,
CompoundTagLike,
CompoundTagTreeInspector,
ItemContentLike,
ItemStackHolder {
    @NotNull
    public ItemType getType();

    @ApiStatus.Obsolete
    @NotNull
    default public ItemType getMaterial() {
        return this.getType();
    }

    public int getAmount();

    @Nullable
    public Component getDisplayName();

    @NotNull
    public @NotNull List<@NotNull Component> getLore();

    @NotNull
    public @NotNull List<@NotNull ItemAttribute> getAttributeModifiers();

    @ApiStatus.Obsolete
    @NotNull
    default public @NotNull List<@NotNull ItemAttribute> getItemAttributes() {
        return this.getAttributeModifiers();
    }

    @NotNull
    public @NotNull List<@NotNull Enchantment> getEnchantments();

    @NotNull
    public ItemData getData();

    @NotNull
    public @NotNull List<@NotNull HideFlags> getHideFlags();

    @Deprecated
    @NotNull
    default public @NotNull List<@NotNull String> getItemFlags() {
        return this.getHideFlags().stream().map(HideFlags::getBukkitName).collect(Collectors.toList());
    }

    @Nullable
    public Integer getCustomModelData();

    public boolean isUnbreakable();

    public int getRepairCost();

    default public int getRepair() {
        return this.getRepairCost();
    }

    @NotNull
    public ItemStackBuilder builder();

    default public boolean isAir() {
        return this.getType().isAir();
    }

    @Override
    default public boolean is(Object ... objects) {
        return this.getType().is(objects);
    }

    @Override
    default public boolean is(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE) @Nullable Object object) {
        return this.getType().is(object);
    }

    public boolean isSimilar(@NotNull ItemStack var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withType(@NotNull ItemType type) {
        return Objects.requireNonNull(this.builder().type(type).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withAmount(int amount) {
        return Objects.requireNonNull(this.builder().amount(amount).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withDisplayName(@Nullable Component displayName) {
        return Objects.requireNonNull(this.builder().displayName(displayName).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withItemLore(@Nullable List<@NotNull Component> lore) {
        return Objects.requireNonNull(this.builder().itemLore(lore).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withAttributeModifiers(@Nullable List<@NotNull ItemAttribute> modifiers) {
        return Objects.requireNonNull(this.builder().attributeModifiers(modifiers).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withAttributeModifier(@NotNull ItemAttribute modifier) {
        return Objects.requireNonNull(this.builder().attributeModifier(modifier).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withData(@NotNull ItemData data) {
        return Objects.requireNonNull(this.builder().data(data).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withHideFlags(@Nullable List<@NotNull HideFlags> flags) {
        return Objects.requireNonNull(this.builder().hideFlags(flags).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withHideFlag(@NotNull HideFlags flag) {
        return Objects.requireNonNull(this.builder().hideFlag(flag).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withEnchantments(@Nullable List<@NotNull Enchantment> enchantments) {
        return Objects.requireNonNull(this.builder().enchantments(enchantments).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withEnchantment(@NotNull Enchantment enchantment) {
        return Objects.requireNonNull(this.builder().enchantment(enchantment).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withCustomModelData(@Nullable Integer customModelData) {
        return Objects.requireNonNull(this.builder().customModelData(customModelData).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withUnbreakable(boolean unbreakable) {
        return Objects.requireNonNull(this.builder().unbreakable(unbreakable).build());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withRepairCost(int repairCost) {
        return Objects.requireNonNull(this.builder().repairCost(repairCost).build());
    }

    @Deprecated
    @Contract(value="_ -> new", pure=true)
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @NotNull
    default public ItemStack withTag(@NotNull CompoundTag tag) {
        return Objects.requireNonNull(this.builder().tag(tag).build());
    }

    @Override
    @Deprecated
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @Nullable
    default public Tag findTag(String ... tagKeys) {
        return this.getTag().findTag(tagKeys);
    }

    @Override
    @Deprecated
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @Nullable
    default public Tag findTag(@NotNull @NotNull Collection<@NotNull String> tagKeys) {
        return CompoundTagTreeInspector.super.findTag(tagKeys);
    }

    @Override
    @Deprecated
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @Nullable
    default public <T extends Tag> T findTag(@NotNull TreeInspectorKey<T> inspectorKey) {
        return CompoundTagTreeInspector.super.findTag(inspectorKey);
    }

    @Override
    @Deprecated
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @Nullable
    default public <T extends Tag> T findTag(@NotNull Class<T> tagClass, String ... tagKeys) {
        return CompoundTagTreeInspector.super.findTag(tagClass, tagKeys);
    }

    @Override
    @Deprecated
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @Nullable
    default public <T extends Tag> T findTag(@NotNull Class<T> tagClass, @NotNull @NotNull Collection<@NotNull String> tagKeys) {
        return CompoundTagTreeInspector.super.findTag(tagClass, tagKeys);
    }

    @Override
    @ApiStatus.Obsolete
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @NotNull
    public CompoundTag getTag();

    @Override
    @ApiStatus.Obsolete
    @LimitedVersionSupport(value="<= 1.20.4; works on >= 1.20.5, but the results may be unexpected, avoid using this method")
    @NotNull
    public CompoundTag asCompoundTag();

    @NotNull
    public ItemStack clone();

    @Override
    @NotNull
    default public ItemContent asItemContent() {
        CompoundTag tag = this.getTag();
        return ItemContent.builder().id(Server.isVersion(1, 13) ? this.getType().location() : ResourceLocation.of(this.getType().platformName())).count(this.getAmount()).tag(tag.isEmpty() ? null : tag).build();
    }
}

