/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i.builder;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.BasicConfigurationNode;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.sl.api.types.server.ItemStackHolder;
import sba.sl.co.ItemStackSerializer;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemStackView;
import sba.sl.i.ItemType;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.impl.item.ItemTypeRegistry;
import sba.sl.impl.item.builder.ShortStackDeserializer;
import sba.sl.u.BidirectionalConverter;
import sba.sl.u.Preconditions;
import sba.sl.u.ReceiverConsumer;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.ide.MinecraftType;

@ProvidedService
@ServiceDependencies(dependsOn={ItemTypeRegistry.class})
public abstract class ItemStackFactory {
    @NotNull
    private static final @NotNull Function<@NotNull ConfigurationNode, @Nullable ItemStack> CONFIGURATE_RESOLVER;
    @NotNull
    protected final BidirectionalConverter<ItemStack> itemConverter = BidirectionalConverter.build().registerW2P(String.class, item -> item.getType().platformName()).registerW2P(ItemType.class, ItemStack::getType).registerP2W(ConfigurationNode.class, CONFIGURATE_RESOLVER).registerP2W(Map.class, map -> {
        try {
            return CONFIGURATE_RESOLVER.apply(BasicConfigurationNode.root().set(map));
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return null;
        }
    }).registerP2W(ItemStack.class, ItemStack::clone);
    @Nullable
    private static ItemStackFactory factory;
    @Nullable
    private static ItemStack cachedAir;

    @ApiStatus.Internal
    public ItemStackFactory() {
        if (factory != null) {
            throw new UnsupportedOperationException("ItemFactory is already initialized.");
        }
        factory = this;
    }

    @NotNull
    public static ItemStackBuilder builder() {
        if (factory == null) {
            throw new UnsupportedOperationException("ItemFactory is not initialized yet.");
        }
        return factory.builder0();
    }

    @NotNull
    public static ItemStackView asView(@NotNull ItemStack item) {
        if (factory == null) {
            throw new UnsupportedOperationException("ItemFactory is not initialized yet.");
        }
        return factory.asView0(item);
    }

    @Contract(value="null -> null")
    @Nullable
    public static ItemStack build(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE) @Nullable Object stack) {
        return ItemStackFactory.readStack(stack);
    }

    @Nullable
    public static ItemStack build(@NotNull @NotNull ReceiverConsumer<@NotNull ItemStackBuilder> builderConsumer) {
        ItemStackBuilder builder = ItemStackFactory.builder();
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static ItemStack build(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE) @Nullable Object stack, @Nullable ReceiverConsumer<@NotNull ItemStackBuilder> builderConsumer) {
        ItemStack item = ItemStackFactory.readStack(stack);
        if (item == null) {
            return null;
        }
        if (builderConsumer != null) {
            ItemStackBuilder builder = item.builder();
            builderConsumer.accept(builder);
            return builder.build();
        }
        return item;
    }

    @Nullable
    public static ItemStack readStack(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE) @Nullable Object stackObject) {
        return ItemStackFactory.factory.itemConverter.convertOptional(stackObject).orElseGet(() -> ItemStackFactory.readShortStack(ItemStackFactory.builder(), stackObject));
    }

    @Nullable
    public static ItemStack readShortStack(@NotNull ItemStack item, @Nullable Object shortStackObject) {
        ItemStackBuilder builder = item.builder();
        ShortStackDeserializer.deserializeShortStack(builder, shortStackObject);
        return builder.build();
    }

    @Nullable
    public static ItemStack readShortStack(@NotNull ItemStackBuilder builder, @Nullable Object shortStackObject) {
        ShortStackDeserializer.deserializeShortStack(builder, shortStackObject);
        return builder.build();
    }

    @NotNull
    public static @NotNull List<@NotNull ItemStack> buildAll(@NotNull List<@Nullable Object> objects) {
        return objects.stream().map(o -> {
            ItemStack item = ItemStackFactory.build(o);
            return item != null ? item : ItemStackFactory.getAir();
        }).collect(Collectors.toList());
    }

    @NotNull
    public static ItemStack getAir() {
        if (cachedAir == null) {
            cachedAir = ItemStackFactory.build("AIR");
            Preconditions.checkNotNullIllegal(cachedAir, "Could not find item: " + String.valueOf(cachedAir));
        }
        return cachedAir.clone();
    }

    public static <T> T convertItem(@NotNull ItemStack item, @NotNull Class<T> newType) {
        if (factory == null) {
            throw new UnsupportedOperationException("ItemFactory is not initialized yet.");
        }
        return ItemStackFactory.factory.itemConverter.convert(item, newType);
    }

    @NotNull
    protected abstract ItemStackBuilder builder0();

    @NotNull
    protected abstract ItemStackView asView0(@NotNull ItemStack var1);

    static {
        ItemStackHolder.Provider.registerProvider(stack -> Objects.requireNonNull(ItemStackFactory.build(stack), "Cannot convert " + String.valueOf(stack) + " to ItemStack"));
        CONFIGURATE_RESOLVER = node -> {
            try {
                return ItemStackSerializer.INSTANCE.deserialize((Type)((Object)ItemStack.class), (ConfigurationNode)node);
            }
            catch (SerializationException e) {
                return null;
            }
        };
    }
}

