/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.k.a.key.Key;
import sba.k.a.t.BuildableComponent;
import sba.k.a.t.ComponentBuilder;
import sba.k.a.t.event.ClickEvent;
import sba.k.a.t.event.HoverEvent;
import sba.k.a.t.event.HoverEventSource;
import sba.k.a.t.format.TextColor;
import sba.k.a.t.format.TextDecoration;
import sba.k.a.util.ARGBLike;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.AdventureColor;
import sba.sl.impl.adventure.spectator.AdventureFeature;
import sba.sl.impl.adventure.spectator.AdventureShadowColor;
import sba.sl.impl.adventure.spectator.event.AdventureClickEvent;
import sba.sl.impl.adventure.spectator.event.AdventureHoverEvent;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.ShadowColor;
import sba.sl.spectator.event.HoverEvent;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;
import sba.sl.u.TriState;
import sba.sl.u.reflect.Reflect;

public class AdventureComponent
extends BasicWrapper<sba.k.a.t.Component>
implements Component {
    public AdventureComponent(@NotNull sba.k.a.t.Component wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull List<@NotNull Component> children() {
        return ((sba.k.a.t.Component)this.wrappedObject).children().stream().map(AdventureBackend::wrapComponent).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public Component withChildren(@Nullable List<@NotNull Component> children) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).children(children == null ? List.of() : children.stream().map(component -> component.as(sba.k.a.t.Component.class)).collect(Collectors.toList())));
    }

    @Override
    @NotNull
    public Component withAppendix(@NotNull Component component) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).append(component.as(sba.k.a.t.Component.class)));
    }

    @Override
    @NotNull
    public Component withAppendix(@NotNull ComponentLike component) {
        return this.withAppendix(component.asComponent());
    }

    @Override
    @NotNull
    public Component withAppendix(Component ... components) {
        if (components.length == 0) {
            return this;
        }
        sba.k.a.t.Component returnC = (sba.k.a.t.Component)this.wrappedObject;
        for (Component child : components) {
            returnC = returnC.append(child.as(sba.k.a.t.Component.class));
        }
        return AdventureBackend.wrapComponent(returnC);
    }

    @Override
    @NotNull
    public Component withAppendix(ComponentLike ... components) {
        if (components.length == 0) {
            return this;
        }
        sba.k.a.t.Component returnC = (sba.k.a.t.Component)this.wrappedObject;
        for (ComponentLike child : components) {
            returnC = returnC.append(child.asComponent().as(sba.k.a.t.Component.class));
        }
        return AdventureBackend.wrapComponent(returnC);
    }

    @Override
    @NotNull
    public Component withAppendix(@NotNull @NotNull Collection<@NotNull Component> components) {
        if (components.isEmpty()) {
            return this;
        }
        sba.k.a.t.Component returnC = (sba.k.a.t.Component)this.wrappedObject;
        for (Component child : components) {
            returnC = returnC.append(child.as(sba.k.a.t.Component.class));
        }
        return AdventureBackend.wrapComponent(returnC);
    }

    @Override
    @Nullable
    public Color color() {
        TextColor color = ((sba.k.a.t.Component)this.wrappedObject).style().color();
        if (color == null) {
            return null;
        }
        return new AdventureColor(color);
    }

    @Override
    @Nullable
    public ShadowColor shadowColor() {
        if (AdventureFeature.SHADOW_COLOR.isSupported()) {
            sba.k.a.t.format.ShadowColor shadowColor = ((sba.k.a.t.Component)this.wrappedObject).style().shadowColor();
            return shadowColor == null ? null : new AdventureShadowColor(shadowColor);
        }
        return null;
    }

    @Override
    @NotNull
    public Component withColor(@Nullable Color color) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).color(color == null ? null : color.as(TextColor.class)));
    }

    @Override
    @NotNull
    public Component withShadowColor(@Nullable ShadowColor color) {
        if (!AdventureFeature.SHADOW_COLOR.isSupported()) {
            return this;
        }
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).shadowColor(color == null ? null : (ARGBLike)color.as(sba.k.a.t.format.ShadowColor.class)));
    }

    @Override
    @Nullable
    public ResourceLocation font() {
        Key font = ((sba.k.a.t.Component)this.wrappedObject).style().font();
        if (font == null) {
            return null;
        }
        return ResourceLocation.of(font.asString());
    }

    @Override
    @NotNull
    public Component withFont(@Nullable ResourceLocation font) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).style(((sba.k.a.t.Component)this.wrappedObject).style().font(font == null ? null : Key.key(font.toString()))));
    }

    @Override
    @NotNull
    public TriState bold() {
        return AdventureComponent.fromAdventure(((sba.k.a.t.Component)this.wrappedObject).style().decoration(TextDecoration.BOLD));
    }

    @Override
    @NotNull
    public Component withBold(boolean bold) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.BOLD, bold));
    }

    @Override
    @NotNull
    public Component withBold(@NotNull TriState bold) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.BOLD, AdventureComponent.toAdventure(bold)));
    }

    @Override
    @NotNull
    public TriState italic() {
        return AdventureComponent.fromAdventure(((sba.k.a.t.Component)this.wrappedObject).style().decoration(TextDecoration.ITALIC));
    }

    @Override
    @NotNull
    public Component withItalic(boolean italic) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.ITALIC, italic));
    }

    @Override
    @NotNull
    public Component withItalic(@NotNull TriState italic) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.ITALIC, AdventureComponent.toAdventure(italic)));
    }

    @Override
    @NotNull
    public TriState underlined() {
        return AdventureComponent.fromAdventure(((sba.k.a.t.Component)this.wrappedObject).style().decoration(TextDecoration.UNDERLINED));
    }

    @Override
    @NotNull
    public Component withUnderlined(boolean underlined) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.UNDERLINED, underlined));
    }

    @Override
    @NotNull
    public Component withUnderlined(@NotNull TriState underlined) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.UNDERLINED, AdventureComponent.toAdventure(underlined)));
    }

    @Override
    @NotNull
    public TriState strikethrough() {
        return AdventureComponent.fromAdventure(((sba.k.a.t.Component)this.wrappedObject).style().decoration(TextDecoration.STRIKETHROUGH));
    }

    @Override
    @NotNull
    public Component withStrikethrough(boolean strikethrough) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.STRIKETHROUGH, strikethrough));
    }

    @Override
    @NotNull
    public Component withStrikethrough(@NotNull TriState strikethrough) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.STRIKETHROUGH, AdventureComponent.toAdventure(strikethrough)));
    }

    @Override
    @NotNull
    public TriState obfuscated() {
        return AdventureComponent.fromAdventure(((sba.k.a.t.Component)this.wrappedObject).style().decoration(TextDecoration.OBFUSCATED));
    }

    @Override
    @NotNull
    public Component withObfuscated(boolean obfuscated) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.OBFUSCATED, obfuscated));
    }

    @Override
    @NotNull
    public Component withObfuscated(@NotNull TriState obfuscated) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).decoration(TextDecoration.OBFUSCATED, AdventureComponent.toAdventure(obfuscated)));
    }

    @Override
    @Nullable
    public String insertion() {
        return ((sba.k.a.t.Component)this.wrappedObject).style().insertion();
    }

    @Override
    @NotNull
    public Component withInsertion(@Nullable String insertion) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).insertion(insertion));
    }

    @Override
    @Nullable
    public HoverEvent hoverEvent() {
        sba.k.a.t.event.HoverEvent<?> hoverEvent = ((sba.k.a.t.Component)this.wrappedObject).style().hoverEvent();
        if (hoverEvent == null) {
            return null;
        }
        return new AdventureHoverEvent(hoverEvent);
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable HoverEvent hoverEvent) {
        return AdventureBackend.wrapComponent((sba.k.a.t.Component)((sba.k.a.t.Component)this.wrappedObject).hoverEvent(hoverEvent == null ? null : (HoverEventSource)hoverEvent.as(sba.k.a.t.event.HoverEvent.class)));
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable ItemContent itemContent) {
        return AdventureBackend.wrapComponent((sba.k.a.t.Component)((sba.k.a.t.Component)this.wrappedObject).hoverEvent(itemContent == null ? null : sba.k.a.t.event.HoverEvent.showItem(itemContent.as(HoverEvent.ShowItem.class))));
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable EntityContent entityContent) {
        return AdventureBackend.wrapComponent((sba.k.a.t.Component)((sba.k.a.t.Component)this.wrappedObject).hoverEvent(entityContent == null ? null : sba.k.a.t.event.HoverEvent.showEntity(entityContent.as(HoverEvent.ShowEntity.class))));
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable Component component) {
        return AdventureBackend.wrapComponent((sba.k.a.t.Component)((sba.k.a.t.Component)this.wrappedObject).hoverEvent(component == null ? null : sba.k.a.t.event.HoverEvent.showText(component.as(sba.k.a.t.Component.class))));
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable ComponentLike component) {
        return this.withHoverEvent(component == null ? null : component.asComponent());
    }

    @Override
    @Nullable
    public sba.sl.spectator.event.ClickEvent clickEvent() {
        ClickEvent clickEvent = ((sba.k.a.t.Component)this.wrappedObject).style().clickEvent();
        if (clickEvent == null) {
            return null;
        }
        return new AdventureClickEvent(clickEvent);
    }

    @Override
    @NotNull
    public Component withClickEvent(@Nullable sba.sl.spectator.event.ClickEvent clickEvent) {
        return AdventureBackend.wrapComponent(((sba.k.a.t.Component)this.wrappedObject).clickEvent(clickEvent == null ? null : clickEvent.as(ClickEvent.class)));
    }

    @Override
    @NotNull
    public String toLegacy() {
        return AdventureBackend.getLegacyComponentSerializer().serialize((sba.k.a.t.Component)this.wrappedObject);
    }

    @Override
    @NotNull
    public String toPlainText() {
        return AdventureBackend.getPlainTextComponentSerializer().serialize((sba.k.a.t.Component)this.wrappedObject);
    }

    @Override
    @NotNull
    public String toJavaJson(boolean emitCompactComponents) {
        if (emitCompactComponents) {
            return AdventureBackend.getJsonComponentSerializer().serialize((sba.k.a.t.Component)this.wrappedObject);
        }
        return AdventureBackend.getJsonComponentSerializerNonCompact().serialize((sba.k.a.t.Component)this.wrappedObject);
    }

    @Override
    public boolean hasStyling() {
        return ((sba.k.a.t.Component)this.wrappedObject).hasStyling();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AdventureBackend.getAdditionalComponentConverter().convert(this, type);
        }
    }

    @NotNull
    private static TriState fromAdventure(@NotNull TextDecoration.State state) {
        switch (state) {
            case TRUE: {
                return TriState.TRUE;
            }
            case FALSE: {
                return TriState.FALSE;
            }
        }
        return TriState.INITIAL;
    }

    private static @NotNull TextDecoration.State toAdventure(@NotNull TriState state) {
        switch (state) {
            case TRUE: {
                return TextDecoration.State.TRUE;
            }
            case FALSE: {
                return TextDecoration.State.FALSE;
            }
        }
        return TextDecoration.State.NOT_SET;
    }

    public static abstract class AdventureBuilder<A extends BuildableComponent<A, D>, B extends Component.Builder<B, C>, C extends Component, D extends ComponentBuilder<A, D>>
    implements Component.Builder<B, C> {
        @NotNull
        private final D builder;

        @NotNull
        protected B self() {
            return (B)this;
        }

        @Override
        @NotNull
        public B color(@NotNull Color color) {
            this.builder.color(color.as(TextColor.class));
            return this.self();
        }

        @Override
        @NotNull
        public B shadowColor(@NotNull ShadowColor color) {
            if (AdventureFeature.SHADOW_COLOR.isSupported()) {
                this.builder.shadowColor((ARGBLike)color.as(sba.k.a.t.format.ShadowColor.class));
            }
            return this.self();
        }

        @Override
        @NotNull
        public B append(@NotNull Component component) {
            this.builder.append(component.as(sba.k.a.t.Component.class));
            return this.self();
        }

        @Override
        @NotNull
        public B append(@NotNull ComponentLike component) {
            this.builder.append(component.asComponent().as(sba.k.a.t.Component.class));
            return this.self();
        }

        @Override
        @NotNull
        public B append(Component ... components) {
            this.builder.append(Arrays.stream(components).map(component -> component.as(sba.k.a.t.Component.class)).collect(Collectors.toList()));
            return this.self();
        }

        @Override
        @NotNull
        public B append(ComponentLike ... components) {
            this.builder.append(Arrays.stream(components).map(component -> component.asComponent().as(sba.k.a.t.Component.class)).collect(Collectors.toList()));
            return this.self();
        }

        @Override
        @NotNull
        public B append(@NotNull @NotNull Collection<@NotNull Component> components) {
            this.builder.append(components.stream().map(component -> component.as(sba.k.a.t.Component.class)).collect(Collectors.toList()));
            return this.self();
        }

        @Override
        @NotNull
        public B font(@Nullable ResourceLocation font) {
            this.builder.font(font == null ? null : Key.key(font.toString()));
            return this.self();
        }

        @Override
        @NotNull
        public B bold(boolean bold) {
            this.builder.decoration(TextDecoration.BOLD, bold);
            return this.self();
        }

        @Override
        @NotNull
        public B bold(@NotNull TriState bold) {
            this.builder.decoration(TextDecoration.BOLD, AdventureComponent.toAdventure(bold));
            return this.self();
        }

        @Override
        @NotNull
        public B italic(boolean italic) {
            this.builder.decoration(TextDecoration.ITALIC, italic);
            return this.self();
        }

        @Override
        @NotNull
        public B italic(@NotNull TriState italic) {
            this.builder.decoration(TextDecoration.ITALIC, AdventureComponent.toAdventure(italic));
            return this.self();
        }

        @Override
        @NotNull
        public B underlined(boolean underlined) {
            this.builder.decoration(TextDecoration.UNDERLINED, underlined);
            return this.self();
        }

        @Override
        @NotNull
        public B underlined(@NotNull TriState underlined) {
            this.builder.decoration(TextDecoration.UNDERLINED, AdventureComponent.toAdventure(underlined));
            return this.self();
        }

        @Override
        @NotNull
        public B strikethrough(boolean strikethrough) {
            this.builder.decoration(TextDecoration.STRIKETHROUGH, strikethrough);
            return this.self();
        }

        @Override
        @NotNull
        public B strikethrough(@NotNull TriState strikethrough) {
            this.builder.decoration(TextDecoration.STRIKETHROUGH, AdventureComponent.toAdventure(strikethrough));
            return this.self();
        }

        @Override
        @NotNull
        public B obfuscated(boolean obfuscated) {
            this.builder.decoration(TextDecoration.OBFUSCATED, obfuscated);
            return this.self();
        }

        @Override
        @NotNull
        public B obfuscated(@NotNull TriState obfuscated) {
            this.builder.decoration(TextDecoration.OBFUSCATED, AdventureComponent.toAdventure(obfuscated));
            return this.self();
        }

        @Override
        @NotNull
        public B insertion(@Nullable String insertion) {
            this.builder.insertion(insertion);
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable HoverEvent event) {
            this.builder.hoverEvent(event == null ? null : (HoverEventSource)event.as(sba.k.a.t.event.HoverEvent.class));
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable ItemContent itemContent) {
            this.builder.hoverEvent(itemContent == null ? null : sba.k.a.t.event.HoverEvent.showItem(itemContent.as(HoverEvent.ShowItem.class)));
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable EntityContent entityContent) {
            this.builder.hoverEvent(entityContent == null ? null : sba.k.a.t.event.HoverEvent.showEntity(entityContent.as(HoverEvent.ShowEntity.class)));
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable ComponentLike component) {
            if (component != null) {
                this.hoverEvent(component.asComponent());
            }
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable Component component) {
            this.builder.hoverEvent(component == null ? null : sba.k.a.t.event.HoverEvent.showText(component.as(sba.k.a.t.Component.class)));
            return this.self();
        }

        @Override
        @NotNull
        public B clickEvent(@Nullable sba.sl.spectator.event.ClickEvent event) {
            this.builder.clickEvent(event == null ? null : event.as(ClickEvent.class));
            return this.self();
        }

        @Override
        public boolean hasStyling() {
            Object result = Reflect.fastInvoke(this.builder, "hasStyle");
            return result instanceof Boolean && (Boolean)result != false;
        }

        @Override
        @NotNull
        public C build() {
            return (C)AdventureBackend.wrapComponent((sba.k.a.t.Component)this.builder.build());
        }

        @Generated
        public AdventureBuilder(@NotNull D builder) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            this.builder = builder;
        }

        @NotNull
        @Generated
        public D getBuilder() {
            return this.builder;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdventureBuilder)) {
                return false;
            }
            AdventureBuilder other = (AdventureBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            D this$builder = this.getBuilder();
            D other$builder = other.getBuilder();
            return !(this$builder == null ? other$builder != null : !this$builder.equals(other$builder));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AdventureBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            D $builder = this.getBuilder();
            result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdventureComponent.AdventureBuilder(builder=" + String.valueOf(this.getBuilder()) + ")";
        }
    }
}

